% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm12_normalize.R
\name{spm12_normalize}
\alias{spm12_normalize}
\title{SPM12 Normalize (Estimate and Write)}
\usage{
spm12_normalize(filename, other.files = NULL, bounding_box = matrix(c(-90,
  -126, -72, 90, 90, 108), nrow = 2, byrow = TRUE), add_spm_dir = TRUE,
  spmdir = spm_dir(), clean = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{filename}{File to be normalized to the template}

\item{other.files}{Files to be written using the estimated
normalization}

\item{bounding_box}{matrix (2x3) of the bounding box to use.  Default is for MNI 2mm template
size}

\item{add_spm_dir}{Add SPM12 directory from this package}

\item{spmdir}{SPM dir to add, will use package default directory}

\item{clean}{Remove scripts from temporary directory after running}

\item{verbose}{Print diagnostic messages}

\item{...}{Arguments passed to \code{\link{run_spm12_script}}}
}
\value{
List of outptu filenames
}
\description{
Performs SPM12 (Spatial) Normalization on an Image
}
