% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersion_initial.R
\name{dispersion_initial}
\alias{dispersion_initial}
\title{Create a dispersion parameter initial object}
\usage{
dispersion_initial(family, dispersion, known)
}
\arguments{
\item{family}{The generalized linear model family describing the distribution
of the response variable to be used. \code{"poisson"}, \code{"nbinomial"}, \code{"binomial"},
\code{"beta"}, \code{"Gamma"}, and \code{"inverse.gaussian"}.}

\item{dispersion}{The value of the dispersion parameter.}

\item{known}{A character vector indicating whether the dispersion parameter is to be
assumed known. The value \code{"dispersion"} or \code{"given"} is assumes
the dispersion parameter is known.}
}
\value{
A list with two elements: \code{initial} and \code{is_known}.
\code{initial} is a named numeric vector indicating the dispersion parameters
with a specified initial and/or known value. \code{is_known} is a named
numeric vector indicating whether the dispersion parameters in
\code{initial} is known or not. The class of the list
matches the value given to the \code{family} argument.
}
\description{
Create a dispersion parameter initial object that specifies
initial and/or known values to use while estimating the dispersion parameter
with \code{\link[=spglm]{spglm()}} or \code{\link[=spgautor]{spgautor()}}.
}
\details{
The \code{dispersion_initial} list is later passed to \code{\link[=spglm]{spglm()}} or \code{\link[=spgautor]{spgautor()}}.

The variance function of an individual \eqn{y} (given \eqn{\mu})
for each generalized linear model family is given below:
\itemize{
\item{family: }{\eqn{Var(y)}}
\item{poisson: }{\eqn{\mu \phi}}
\item{nbinomial: }{\eqn{\mu + \mu^2 / \phi}}
\item{binomial: }{\eqn{n \mu (1 - \mu) \phi}}
\item{beta: }{\eqn{\mu (1 - \mu) / (1 + \phi)}}
\item{Gamma: }{\eqn{\mu^2 / \phi}}
\item{inverse.gaussian: }{\eqn{\mu^2 / \phi}}
}
The parameter \eqn{\phi} is a dispersion parameter that influences \eqn{Var(y)}.
For the \code{poisson} and \code{binomial} families, \eqn{\phi} is always
one. Note that this inverse Gaussian parameterization is different than a
standard inverse Gaussian parameterization, which has variance \eqn{\mu^3 / \lambda}.
Setting \eqn{\phi = \lambda / \mu} yields our parameterization, which is
preferred for computational stability. Also note that the dispersion parameter
is often defined in the literature as \eqn{V(\mu) \phi}, where \eqn{V(\mu)} is the variance
function of the mean. We do not use this parameterization, which is important
to recognize while interpreting dispersion parameter estimates using \code{\link[=spglm]{spglm()}} or \code{\link[=spgautor]{spgautor()}}.
For more on generalized linear model constructions, see McCullagh and
Nelder (1989).
}
\examples{
# known dispersion value 1
dispersion_initial("nbinomial", dispersion = 1, known = "dispersion")
}
\references{
McCullagh P. and Nelder, J. A. (1989) \emph{Generalized Linear Models}. London: Chapman and Hall.
}
