% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.obis.R
\name{as.obis}
\alias{as.obis}
\title{Coerce occurrence keys to obis id objects}
\usage{
as.obis(x)
}
\arguments{
\item{x}{Various inputs, including the output from a call to 
\code{\link{occ}} (class occdat), \code{\link{occ2df}} (class data.frame), 
or a list, numeric, obiskey, or occkey.}
}
\value{
One or more in a list of both class obiskey and occkey
}
\description{
Coerce occurrence keys to obis id objects
}
\examples{
\dontrun{
spnames <- c('Mola mola', 'Loligo vulgaris', 'Stomias boa')
out <- occ(query=spnames, from='obis', limit=2)
(res <- occ2df(out))
(tt <- as.obis(out))
(uu <- as.obis(res))
as.obis(x = res$key[1])
as.obis(as.list(res$key[1:2]))
as.obis(tt[[1]])
as.obis(uu[[1]])
as.obis(tt[1:2])

library("data.table")
rbindlist(tt, use.names = TRUE, fill = TRUE)
}
}

