% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-baseball.R
\name{baseball_foul_line}
\alias{baseball_foul_line}
\title{The foul line. These are the white lines that extend from the back tip of
home plate (but not visibly through the batter's boxes) out to the fair/foul
pole in the outfield. Since a ball on the line is considered in fair
territory, the outer edge of the baseline must lie in fair territory (aka the
line y = +/- x)}
\usage{
baseball_foul_line(
  is_line_1b = FALSE,
  line_distance = 0,
  batters_box_length = 0,
  batters_box_width = 0,
  batters_box_y_adj = 0,
  home_plate_side_to_batters_box = 0,
  foul_line_thickness = 0
)
}
\arguments{
\item{is_line_1b}{Whether or not the line is the first base line}

\item{line_distance}{The straight-line distance from the back tip of home
plate to the terminus of the line at the foul pole}

\item{batters_box_length}{The length of the batter's box (in the y direction)
measured from the outside of the chalk lines}

\item{batters_box_width}{The width of the batter's box (in the x direction)
measured from the outside of the chalk lines}

\item{batters_box_y_adj}{The shift off of center in the y direction that the
batter's box is to be moved to properly align}

\item{home_plate_side_to_batters_box}{The distance from the outer edge of the
batter's box to the inner edge of home plate}

\item{foul_line_thickness}{The thickness of the chalk line that comprise the
foul line}
}
\value{
A data frame containing the foul line's bounding coordinates
}
\description{
The foul line. These are the white lines that extend from the back tip of
home plate (but not visibly through the batter's boxes) out to the fair/foul
pole in the outfield. Since a ball on the line is considered in fair
territory, the outer edge of the baseline must lie in fair territory (aka the
line y = +/- x)
}
\keyword{internal}
