% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inclusion_prob.R
\name{inclusion_prob}
\alias{inclusion_prob}
\title{Calculate inclusion probabilities}
\usage{
inclusion_prob(x, n, strata = gl(1, length(x)), alpha = 0.001, cutoff = Inf)
}
\arguments{
\item{x}{A positive and finite numeric vector of sizes for units in the
population (e.g., revenue for drawing a sample of businesses).}

\item{n}{A positive integer vector giving the sample size for each stratum,
ordered according to the levels of \code{strata}. A single value is recycled
for all strata. Non-integers are truncated towards 0.}

\item{strata}{A factor, or something that can be coerced into one, giving
the strata associated with units in the population. The default is to place
all units into a single stratum.}

\item{alpha}{A numeric vector with values between 0 and 1 for each stratum,
ordered according to the levels of \code{strata}. Units with inclusion
probabilities greater than or equal to 1 - \code{alpha} are set to 1 for
each stratum. A single value is recycled for all strata. The default is
slightly larger than 0.}

\item{cutoff}{A positive numeric vector of cutoffs for each stratum, ordered
according to the levels of \code{strata}. Units with \code{x >= cutoff} get
an inclusion probability of 1 for each stratum. A single value is recycled
for all strata. The default does not apply a cutoff.}
}
\value{
A numeric vector of inclusion probabilities for each unit in the population.
}
\description{
Calculate stratified (first-order) inclusion probabilities.
}
\details{
Within a stratum, the inclusion probability for a unit is given by
\eqn{\pi = nx / \sum x}{\pi = n * x / \sum x}. These values can be greater
than 1 in practice, and so they are constructed iteratively by taking units
with \eqn{\pi \geq 1 - \alpha}{\pi >= 1 - \alpha} (from largest to smallest)
and assigning these units an inclusion probability of 1, with the remaining
inclusion probabilities recalculated at each step. If \eqn{\alpha > 0}, then
any ties among units with the same size are broken by their position.
}
\examples{
# Make a population with units of different size
x <- c(1:10, 100)

# Use the inclusion probabilities to calculate the variance of the
# sample size for Poisson sampling
pi <- inclusion_prob(x, 5)
sum(pi * (1 - pi))

}
\seealso{
\code{\link[=sps]{sps()}} for drawing a sequential Poisson sample.
}
