% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsUIcollections.R
\name{hrefTable}
\alias{hrefTable}
\title{A table of hyper reference buttons}
\usage{
hrefTable(
  item_titles,
  item_labels,
  item_hrefs,
  item_title_colors = "#0275d8",
  item_bg_colors = "#337ab7",
  item_text_colors = "white",
  Id = NULL,
  first_col_name = "Category",
  second_col_name = "Options",
  title = "A Table buttons with links",
  title_color = "#0275d8",
  ...
)
}
\arguments{
\item{item_titles}{vector of strings, a vector of titles for table row names}

\item{item_labels}{list, a list of character vectors to specify button
labels in each table row, one vector per row}

\item{item_hrefs}{list, a list  of character vectors to specify button hrefs
links in each table row, one vector per row}

\item{item_title_colors}{a single character value or a character vector to
specify button title text colors of each row name}

\item{item_bg_colors}{a single character value or a list, a list  of character
vectors to specify button background colors in each table row, one vector per row}

\item{item_text_colors}{a single character value or a list, a list  of character
vectors to specify button text colors in each table row, one vector per row}

\item{Id}{optional ID}

\item{first_col_name}{first column name}

\item{second_col_name}{second column name}

\item{title}{title of this table}

\item{title_color}{table title color}

\item{...}{other HTML param you want to pass to the table}
}
\value{
HTML elements
}
\description{
creates a table in Shiny which the cells are hyper reference (links)
buttons. This function is similar to \link{hrefTab}, but that function only creates
a single row of link buttons, and this function creates a table of rows.

The table has two columns, the first column is row names, second column is different
link buttons.
}
\details{
\enumerate{
\item \code{item_titles}, \code{item_labels}, \code{item_hrefs} must have the same
length. Each vector in \code{item_labels}, \code{item_hrefs} must also have the same
length. For example, if we want to make a table of two rows, the first row
has 1 cell and the second row has 2 cells:
}\preformatted{ hrefTable(
     item_titles = c("row 1", "row 2"),
     item_labels = list(c("cell 1"), c("cell 1", "cell 2")),
     item_hrefs = list(c("link1"), c("link1", "link2")
 )
}
\enumerate{
\item If \code{item_title_colors}, \code{item_text_colors} are given more than one value,
the list must have the same length as \code{item_titles}, and length of each vector
in the list must match the vector in \code{item_labels} in the same order.
\item If  \code{item_title_colors} is given more than one value, the vector must have
the same length as \code{item_titles}.
\item Use \code{""} to occupy the space if you do not want a label contains a link,
e.g \code{item_hrefs = list(c("https://www.google.com/"), c("", ""))}
\item If a label does not have a link, you cannot click it and there is no hovering
effects.
}
}
\examples{
if(interactive()){
    ui <- fluidPage(
        hrefTable(
            title = "default",
            item_titles = c("workflow 1", "unclickable"),
            item_labels = list(c("tab 1"), c("tab 3", "tab 4")),
            item_hrefs = list(c("https://www.google.com/"), c("", ""))
        ),
        hrefTable(
            title = "Change button color and text color",
            item_titles = c("workflow 1", "No links"),
            item_labels = list(c("tab 1"), c("tab 3", "tab 4")),
            item_hrefs = list(c("https://www.google.com/"), c("", "")),
            item_bg_colors =  list(c("blue"), c("red", "orange")),
            item_text_colors =  list(c("black"), c("yellow", "green"))
        ),
        hrefTable(
            title = "Change row name colors and width",
            item_titles = c("Green", "Red", "Orange"),
            item_labels = list(c("tab 1"), c("tab 3", "tab 4"), c("tab 5", "tab 6", "tab 7")),
            item_hrefs = list(
                c("https://www.google.com/"),
                c("", ""),
                c("https://www.google.com/", "https://www.google.com/", "")
            ),
            item_title_colors = c("green", "red", "orange"),
            style = "width: 50\%"
        )

    )

    server <- function(input, output, session) {

    }

    shinyApp(ui, server)
}
}
