% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sncFun.R
\name{sncFun}
\alias{sncFun}
\title{Non-capillary Saturation Function to Extend Other Functions}
\usage{
sncFun(h, scap)
}
\arguments{
\item{h}{A vector of \code{n} pressure head values for which \code{scap} was calculated}

\item{scap}{vector of \code{n} monotonically decreasing capillary saturation function values calculated by \code{shypFun}, rescaled between 0 and 1.}
}
\value{
A vector of \code{n} elements with calculated saturation content of the non-capillary part.
}
\description{
The general purpose method to calculate numerically the effective non-capillary saturation is directly obtained from any arbritrary expression for the 
rescaled capillary saturation function as described by \insertCite{Weber.2019}{spsh}. Examples of capillary saturation functions are the well known \insertCite{vanGenuchten.1980}{spsh}, \insertCite{Kosugi.1996}{spsh}, \insertCite{Fredlund.1994}{spsh} functions.
}
\examples{
# set variables
p <- c(0.1, 0.4, 0.01, 2, 100, .5)
h <- 10^seq(-2, 6.8, length = 197)

# Calculate the capillary and non-capillary saturation function.
Se <- shypFun(p, h, shpmodel = "01110")$Se     
Snc <- sncFun(Se)

}
\references{
\insertRef{vanGenuchten.1980}{spsh}\cr
\insertRef{Kosugi.1996}{spsh}\cr
\insertRef{Fredlund.1994}{spsh}\cr
}
\author{
Tobias KD Weber , \email{tobias.weber@uni-hohenheim.de}
}
