\name{parATimePredict}
\alias{parATimePredict}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Batch Prediction for Time Series Using the Ensemble Models}
\description{
   Batch predictions for the time series using ensemble models generated by the function, parSpModel
}
\usage{
parATimePredict(mdPath,newPnts,cols=NA,bnd,c=1,outPath="/tmp",idF="siteid",ridF="rid")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{mdPath}{The path where multiple ensemble models are saved by parSpModel}
  \item{newPnts}{New data locations corresponding to the predcitions.}
  \item{cols}{Columns where there are NAs.  NAs must be removed before prediction.  Default: NA }
  \item{bnd}{The same BND object as that used in parSpModel, for spatial effect models. }
  \item{c}{CPU cores to support parallel computing. }
  \item{outPath}{The output file path, file named after the model id. }
  \item{idF}{Unique identifier }
  \item{ridF}{Region id used in spatial effect modeling }
}
\details{
  This function aims to use the muiltiple models with their performance metrics to make the predictions for the new dataset with their spatial location.
}
\value{The prediction result will be saved in the assigned path}
\references{
Breiman, L., 1996. Bagging Predictors. Machine Learning 24, 123-140.
Lianfa Li et al, 2017, Constrained Mixed-Effect Models with Ensemble Learning for Prediction of Nitrogen Oxides Concentrations at High Spatiotemporal Resolution, ES & T, DOI: 10.1021/acs.est.7b01864

}
\author{ Lianfa Li \email{lspatial@gmail.com}}

\examples{

\donttest{
#Use the PM2.5 examples

dPath=tempdir()
modelPath=paste(dPath,"/models",sep="")
unlink(modelPath,recursive = TRUE)
dir.create(modelPath)

prePath=paste(dPath,"/preds",sep="")
unlink(prePath,recursive = TRUE)
dir.create(prePath)

data("trainsample","bnd")
aform=paste0('logpm25 ~sx(rid,bs ="mrf",map =bnd)+sx(monthAv,bs="rw2")')
aform=paste0(aform,'+sx(ndvi,bs="rw2")+sx(aod,bs="rw2")+sx(wnd_avg,bs="rw2")')

formulaStrs=c(aform)

trainsample$tid=as.numeric(strftime(trainsample$date, format = "\%j"))

trainsample$logpm25=log(trainsample$pm25)
tids=c(91)

parSpModel(trainsample,bnd,formulaStrs,tidF="tid",tids,c=2,
       nM=3,modelPath,idF="siteid",dateF="date",obsF="pm25")

amodelPath=paste(dPath,"/models/t_",tids[1],"_models",sep="")
data("shd140401pcovs","bnd")
shd140401pcovs_part=shd140401pcovs[c(1:1000),]

cols=c("aod","ndvi","wnd_avg","monthAv")
parATimePredict(amodelPath,newPnts=shd140401pcovs_part,
       cols,bnd=bnd,c=2,prePath,idF="gid",ridF="rid")
}

}

\keyword{ timeseries }
