% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updatetable.R
\name{updatetable}
\alias{updatetable}
\title{Generate a SQL UPDATE statement from a mapping file}
\usage{
updatetable(inputfile = NULL, tablename = NULL)
}
\arguments{
\item{inputfile}{Dataframe OR path to the mapping file}

\item{tablename}{Name of the SQL table}
}
\value{
A string that represents the constructed UPDATE statement(s)
}
\description{
This function constructs an UPDATE statement from a mapping file or
dataframe. It assumes that the first column of the data contains the
key column and list of keys for the rows where the corresponding other columns
have to be updated. It also assumes that the header for the data includes the
column names. The function will generate one UPDATE statement for each row in
the data.
}
\examples{
 input <- Data_Frame <- data.frame(Training = c("Strength", "Stamina",
  "Other"), Pulse = c(100, 150, 120), Duration = c(60, 30, 45))
 result <- updatetable(inputfile = input, tablename = "myTable")
}
