% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey_statistics.r
\name{survey_corr}
\alias{survey_corr}
\title{Calculate correlation and its variation using survey methods}
\usage{
survey_corr(
  x,
  y,
  na.rm = FALSE,
  vartype = c("se", "ci", "var", "cv"),
  level = 0.95,
  df = NULL,
  ...
)
}
\arguments{
\item{x}{A variable or expression}

\item{y}{A variable or expression}

\item{na.rm}{A logical value to indicate whether missing values should be dropped}

\item{vartype}{NULL to report no variability. Otherwise one or more of: standard error ("se", the default), confidence interval ("ci"), variance ("var") or coefficient of variation ("cv").}

\item{level}{(For vartype = "ci" only) A single number or vector of numbers indicating the confidence level}

\item{df}{(For vartype = "ci" only) A numeric value indicating the degrees of freedom for t-distribution. The default (NULL) uses degf, but Inf is the usual survey package's default}

\item{...}{Ignored}
}
\description{
Calculate correlation from complex survey data. A wrapper
around \code{\link[survey]{svyvar}}. \code{survey_corr} should always be
called from \code{\link{summarise}}. Note this is Pearson's correlation.
}
\examples{
data('api', package = 'survey')

apisrs \%>\%
  as_survey_design(.ids = 1) \%>\%
  summarize(api_corr = survey_corr(x = api00, y = api99))

apisrs \%>\%
  as_survey_design(.ids = 1) \%>\%
  group_by(sch.wide) \%>\%
  summarize(
    api_emer_corr = survey_corr(x = api00, y = emer, na.rm=TRUE, vartype="ci")
  )
}
