% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{language}
\alias{language}
\title{Mouse-tracking experiment of a lexical decision task}
\format{A long-format dataframe of 6060 observations containing 
  information on the following variables.
\describe{
 \item{sbj}{The ID number of participants}
 \item{condition}{A factor of levels \code{HF}, \code{LF}, \code{PW}, \code{NW} indicating the type of stimulus}
 \item{timestep}{The ID number of the recorded x-y trajectories} 
 \item{x}{The recorded x-trajectories}
 \item{y}{The recorded y-trajectories}
 \item{trial}{The ID number of trials}
}}
\source{
Barca, L., & Pezzulo, G. (2012). 
Unfolding visual lexical decision in time. 
\emph{PloS one}, 7(4), e35932.
}
\usage{
language
}
\description{
This dataset contains a subset of data originally presented in Barca & Pezzullo (2012). In this task 
participants see a printed stimulus on the screen (e.g., water) and are requested 
to perform a dichotomous choice task where the stimulus can be classified as word or non-word. The experimental variable is the \emph{stimulus type} with four categorical levels (i.e., high-frequency word, low-frequency word, pseudowords, and strings of letters). 
Participants have to classify each stimulus as belonging to word or non-word categories. 

The dataset contains five participants (I=5), each measured along three trials, one categorical variable (Q=1) with four levels (K=4). The total number of trials is J=12. 
Mouse-tracking trajectories have previously been pre-processed with N=101 timesteps, translated into the first quadrant,
and rotated so that the Target point (y_T) is always on the right-side.
}
\keyword{datasets}
