% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burrrIII3.R
\name{burrIII3}
\alias{burrIII3}
\alias{dburrIII3}
\alias{qburrIII3}
\alias{pburrIII3}
\alias{rburrIII3}
\alias{sburrIII3}
\title{Burr Type III Three-Parameter Distribution}
\usage{
dburrIII3(x, lshape1 = 0, lshape2 = 0, lscale = 0, log = FALSE)

qburrIII3(
  p,
  lshape1 = 0,
  lshape2 = 0,
  lscale = 0,
  lower.tail = TRUE,
  log.p = FALSE
)

pburrIII3(
  q,
  lshape1 = 0,
  lshape2 = 0,
  lscale = 0,
  lower.tail = TRUE,
  log.p = FALSE
)

rburrIII3(n, lshape1 = 0, lshape2 = 0, lscale = 0)

sburrIII3(x)
}
\arguments{
\item{x}{The object.}

\item{lshape1}{shape1 parameter on the log scale.}

\item{lshape2}{shape2 parameter on the log scale.}

\item{lscale}{scale parameter on the log scale.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \code{P[X <= x]},otherwise, \code{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{n}{number of observations.}
}
\value{
dburrIII3 gives the density, pburrIII3 gives the distribution function,
qburrIII3 gives the quantile function, and rburrIII3 generates random samples.
}
\description{
Density, distribution function, quantile function and random generation
for the Burr Type III Three-Parameter distribution with
\code{lshape} and \code{lscale} parameters.
}
\details{
The Burr 12 distribution from the actuar package is used as a base.
The Burr III distribution is the distribution of 1/x where x has the Burr Type 12 distribution.
refer to https://www.itl.nist.gov/div898/software/dataplot/refman2/auxillar/bu3pdf.htm for details.
The shape1, shape2, and scale parameters are on the log(scale) as these must be positive.
}
\examples{
x <- rburrIII3(1000)
hist(x, freq = FALSE, col = "gray", border = "white")
curve(dburrIII3(x), add = TRUE, col = "red4", lwd = 2)
}
\seealso{
\code{\link[actuar:Burr]{actuar::dburr()}}
}
