% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hp.R
\name{ssd_hp}
\alias{ssd_hp}
\alias{ssd_hp.fitdist}
\alias{ssd_hp.fitdistcens}
\alias{ssd_hp.fitdists}
\alias{ssd_hp.fitdistscens}
\title{Hazard Percent}
\usage{
ssd_hp(x, ...)

\method{ssd_hp}{fitdist}(
  x,
  conc,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  parallel = NULL,
  ncpus = 1,
  ...
)

\method{ssd_hp}{fitdistcens}(
  x,
  conc,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  parallel = NULL,
  ncpus = 1,
  ...
)

\method{ssd_hp}{fitdists}(
  x,
  conc,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  parallel = NULL,
  ncpus = 1,
  average = TRUE,
  ic = "aicc",
  ...
)

\method{ssd_hp}{fitdistscens}(
  x,
  conc,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  parallel = NULL,
  ncpus = 1,
  average = TRUE,
  ic = "aic",
  ...
)
}
\arguments{
\item{x}{The object.}

\item{...}{Unused.}

\item{conc}{A numeric vector of concentrations.}

\item{ci}{A flag specifying whether to estimate confidence intervals (by parametric bootstrapping).}

\item{level}{A number between 0 and 1 of the confidence level.}

\item{nboot}{A count of the number of bootstrap samples to use to estimate the se and confidence limits.}

\item{parallel}{A string specifying the type of parallel operation to be used ('no', 'snow' or 'multicore').}

\item{ncpus}{A count of the number of parallel processes to use.}

\item{average}{A flag specifying whether to model average the estimates.}

\item{ic}{A string specifying which information-theoretic criterion ('aic', 'aicc' or 'bic') to use for model averaging .}
}
\value{
A data frame of the conc and percent.
}
\description{
Gets percent species protected at specified concentrations.
}
\section{Methods (by class)}{
\itemize{
\item \code{fitdist}: Hazard Percent fitdist

\item \code{fitdistcens}: Hazard Percent fitdistcens

\item \code{fitdists}: Hazard Percent fitdists

\item \code{fitdistscens}: Hazard Percent fitdistcens
}}

\examples{
ssd_hp(boron_lnorm, c(0, 1, 30, Inf))
ssd_hp(fluazinam_lnorm, c(0, 1, 30, Inf))
ssd_hp(boron_dists, c(0, 1, 30, Inf))
ssd_hp(fluazinam_dists, c(0, 1, 30, Inf))
}
