% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.R
\name{ssd_gof}
\alias{ssd_gof}
\alias{ssd_gof.fitdists}
\title{Goodness of Fit}
\usage{
ssd_gof(x, ...)

\method{ssd_gof}{fitdists}(x, pvalue = FALSE, ...)
}
\arguments{
\item{x}{The object.}

\item{...}{Unused.}

\item{pvalue}{A flag specifying whether to return p-values or the statistics (default) for the various tests.}
}
\value{
A tbl data frame of the gof statistics.
}
\description{
Returns a tbl data frame with the following columns
\describe{
\item{dist}{The distribution name (chr)}
\item{aic}{Akaike's Information Criterion (dbl)}
\item{bic}{Bayesian Information Criterion (dbl)}
}
and if the data are non-censored
\describe{
\item{aicc}{Akaike's Information Criterion corrected for sample size (dbl)}
}
and if there are 8 or more samples
\describe{
\item{ad}{Anderson-Darling statistic (dbl)}
\item{ks}{Kolmogorov-Smirnov statistic (dbl)}
\item{cvm}{Cramer-von Mises statistic (dbl)}
}
In the case of an object of class fitdists the function also returns
\describe{
\item{delta}{The Information Criterion differences (dbl)}
\item{weight}{The Information Criterion weights (dbl)}
}
where \code{delta} and \code{weight} are based on \code{aic} for censored data
and \code{aicc} for non-censored data.
}
\section{Methods (by class)}{
\itemize{
\item \code{fitdists}: Goodness of Fit
}}

\examples{
fits <- ssd_fit_dists(ssddata::ccme_boron)
ssd_gof(fits)
ssd_gof(fits)
}
\seealso{
\code{\link[=glance.fitdists]{glance.fitdists()}}
}
