% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_functions.R
\name{tcc_find_pairs}
\alias{tcc_find_pairs}
\title{Reorders components of different PARAFAC models according to best fit (TCC)}
\usage{
tcc_find_pairs(fits)
}
\arguments{
\item{fits}{list of parafac models}
}
\value{
list of parafac models
}
\description{
When running a splithalf analysis similar components are not necessarily on the same position. This function looks for best fits with Tucker's Congruence Coefficients and returns a list of models with reordered components.
}
\examples{
\donttest{
data(eem_list)

# function currently only used from within splithalf
splithalf(eem_list, 6, nstart = 2, cores = 2)
}
}
\seealso{
\code{\link[staRdom]{splithalf}}
}
