% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{mae}
\alias{mae}
\alias{rmse}
\alias{mad}
\title{Regression error and deviation measures}
\usage{
mae(actual, pred, na.rm = FALSE)

rmse(actual, pred, na.rm = FALSE)

mad(x, na.rm = FALSE, version = "mean", ...)
}
\arguments{
\item{actual}{numeric vector. Actual (true) values of target outcome data.}

\item{pred}{numeric vector. Predictions corresponding to each respective element in \code{actual}.}

\item{na.rm}{logical(1). \code{TRUE} if missing values should be removed; \code{FALSE} if they should be retained. If \code{TRUE}, then if any element of either \code{actual} or \code{pred} is missing, its paired element will be also removed.}

\item{x}{numeric vector. Values for which to calculate the MAD.}

\item{version}{character(1). By default (\code{version = 'mean'}), \code{mad()} returns the mean absolute deviation (MAD) of values relative to their mean. If \code{version = 'median'}, it calls the \code{stats::mad()} function instead, the median absolute deviation relative to their median (MedAD, sometimes also called MAD). Any other value gives an error. See details.}

\item{...}{Arguments to pass to \code{stats::mad()} if \code{version = 'median'}. See the \code{version} argument for details.}
}
\value{
In all cases, if any value in \code{actual} or \code{pred} is \code{NA} and \code{na.rm = FALSE}, then the function returns \code{NA}.

\code{mae()} returns the mean absolute error (MAE) of predicted values \code{pred} compared to the \code{actual} values.

\code{rmse()} returns the root mean squared error (RMSE) of predicted values \code{pred} compared to the \code{actual} values.

\code{mad()} returns either the mean absolute deviation (MAD) of values relative to their mean (default) or the median absolute deviation relative to their median. See details.
}
\description{
These are standard error and deviation measures for numeric data. "Deviation" means the natural variation of the values of a numeric vector around its central tendency (usually the mean or median). "Error" means the average discrepancy between the actual values of a numeric vector and its predicted values.
}
\details{
\strong{Mean absolute deviation (MAD)}

\code{mad()} returns the mean absolute deviation (MAD) of values relative to their mean. This is useful as a default benchmark for the mean absolute error (MAE), as the standard deviation (SD) is a default benchmark for the root mean square error (RMSE).

\strong{NOTE:} This function name overrides \code{stats::mad()} (median absolute deviation relative to their median). To maintain the functionality of \code{stats::mad()}, specify the \code{version} argument.
}
\examples{
a <- c(3, 5, 2, 7, 9, 4, 6, 8, 1, 10)
p <- c(2.5, 5.5, 2, 6.5, 9.5, 3.5, 6, 7.5, 1.5, 9.5)
mae(a, p)

rmse(a, p)

mad(a)

}
