% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tarone.R
\name{Tarone.test}
\alias{Tarone.test}
\title{Tarone's Z Test}
\usage{
Tarone.test(N, M)
}
\arguments{
\item{N}{Trials}

\item{M}{Counts}
}
\value{
a \code{htest} object
}
\description{
Tests the goodness of fit of the binomial distribution.
}
\examples{
 #Generate example data
N <- c(30, 32, 40, 28, 29, 35, 30, 34, 31, 39)
M <- c( 9, 10, 22, 15,  8, 19, 16, 19, 15, 10)
Tarone.test(N, M)
}
\references{
\url{https://stats.stackexchange.com/a/410376/6378} and
R. E. TARONE, Testing the goodness of fit of the binomial distribution, Biometrika, Volume 66, Issue 3, December 1979, Pages 585–590, \url{https://doi.org/10.1093/biomet/66.3.585}
}
\author{
\href{https://stats.stackexchange.com/users/173082/reinstate-monica}{Ben O'Neill}
}
