require(stacomiR)
# launching stacomi without selecting the scheme or interface
stacomi(gr_interface=FALSE,
	login_window=FALSE,
	database_expected=FALSE)
\dontrun{
  #create an instance of the class
  r_gew<-new("report_ge_weight")
  baseODBC<-get("baseODBC",envir=envir_stacomi)
  baseODBC[c(2,3)]<-rep("iav",2)
  assign("baseODBC",baseODBC,envir_stacomi)
  sch<-get("sch",envir=envir_stacomi)
  assign("sch","iav.",envir_stacomi)
  r_gew@liste<-charge(object=r_gew@liste,listechoice=c("=1",">1","tous"),label="")
  # here I'm using weights when number are larger than 1 ie wet weight
  # always choose a date from one year to the next eg 2010 to 2011
  # as the dates are from august to august
  r_gew<-choice_c(r_gew,
	  dc=c(6),			
	  anneedebut="2009",
	  anneefin="2015",
	  selectedvalue=">1",
	  silent=FALSE)
  r_gew<-connect(r_gew)	
  r_gew<-calcule(r_gew)
}	
# load the dataset generated by previous lines
data("r_gew")
# the calculation will fill the slot calcdata

# A ggplot showing the trend in weight
plot(r_gew, plot.type=1)
# A plot showing both the data and the trend as recorded in the database
plot(r_gew, plot.type=2)
# Same as plot.type=1 but with size according to size of the sample,
# usefull for wet weights where weight are recorded on a number of glass eel
plot(r_gew, plot.type=3)
\dontrun{
# First model with nls, see Guerault and Desaunay (1993) 
  model(r_gew,model.type="seasonal")
  model(r_gew,model.type="seasonal1")
}
