context("report_mig_char")


test_that("test creating an instance of report_mig_char and connect method (logrami required)",
          {
            skip_on_cran()
            stacomi(database_expected = TRUE, sch ="logrami")
						env_set_test_stacomi()            # here parqual is not in the list
            # so this is equivalent to parqual=NULL
            r_mig_char <- choice_c(
              r_mig_char,
              dc = c(107, 108, 101),
              taxa = c("Salmo salar"),
              stage = c('5', '11', 'BEC', 'BER', 'IND'),
              parquan = c('A124', 'C001'),
              parqual = NULL,
              horodatedebut = "2009-01-01",
              horodatefin = "2012-12-31",
              silent = TRUE
            )
            # r_mig_char<-charge(r_mig_char) not necessary there
            r_mig_char <- connect(r_mig_char)
            expect_true(is.null(r_mig_char@data$parqual), label = "there should be no data in parqual when not qualitative parm are selected")
            expect_true(
              nrow(r_mig_char@data$parquan) > 0,
              "There should be data in the parquan slot when quantitative parm are selected"
            )
            rm(list = ls(envir = envir_stacomi), envir = envir_stacomi)
						
          })

test_that("test setasqualitative method", {
  skip_on_cran()
  stacomi(database_expected = TRUE, sch = "logrami")
	env_set_test_stacomi()
  # here parqual is not in the list
  # so this is equivalent to parqual=NULL
  r_mig_char <- choice_c(
    r_mig_char,
    dc = c(107, 108, 101),
    taxa = c("Salmo salar"),
    stage = c('5', '11', 'BEC', 'BER', 'IND'),
    parquan = c('A124', 'C001'),
    parqual = NULL,
    horodatedebut = "2009-01-01",
    horodatefin = "2012-12-31",
    silent = TRUE
  )
  # r_mig_char<-charge(r_mig_char) not necessary there
  r_mig_char <- connect(r_mig_char, silent = TRUE)
  # load the dataset generated by previous lines
  r_mig_char <- setasqualitative(
    r_mig_char,
    par = 'A124',
    silent = TRUE,
    breaks = c(0, 1.5, 2.5, 10),
    label = c("age 1", "age 2", "age 3")
  )
  expect_true(r_mig_char@parqual@par_selected == 'A124', label = "Test passing quant parm A124 to qualitative failed")
  expect_false(r_mig_char@parquan@par_selected == 'A124', label = "The parameter A124 should have been removed from quant parm")
  expect_true('A124' %in% r_mig_char@data$parqual$car_par_code)
  expect_false('A124' %in% r_mig_char@data$parquan$car_par_code)
  rm(list = ls(envir = envir_stacomi), envir = envir_stacomi)
	
})


test_that("test calcule method", {
  skip_on_cran()
  stacomi(database_expected = TRUE, sch ="logrami")
	env_set_test_stacomi()
  r_mig_char <- choice_c(
    r_mig_char,
    dc = c(107, 108, 101),
    taxa = c("Salmo salar"),
    stage = c('5', '11', 'BEC', 'BER', 'IND'),
    parquan = c('A124', 'C001'),
    parqual = NULL,
    horodatedebut = "2012-01-01",
    horodatefin = "2012-12-31",
    silent = TRUE
  )
  r_mig_char <- connect(r_mig_char)
  r_mig_char <- calcule(r_mig_char, silent = TRUE)
  expect_true(nrow(r_mig_char@calcdata) > 0, label = "Test that calcule method worked")
  expect_true(all(is.na(
    r_mig_char@calcdata$car_par_code_qual
  )), label = "Test that calcule method does not return any qualitative result in absence of qualitative parm")
  
  # now with a qualitative parm
  r_mig_char <- setasqualitative(
    r_mig_char,
    par = 'A124',
    silent = TRUE,
    breaks = c(0, 1.5, 2.5, 10),
    label = c("age 1", "age 2", "age 3")
  )
  r_mig_char <- calcule(r_mig_char, silent = TRUE)
  expect_true(any(!is.na(
    r_mig_char@calcdata$car_par_code_qual
  )) &
    any(!is.na(
      r_mig_char@calcdata$car_par_code_quan
    )), label = "The merge function works and returns both qualitative and quantitative parameters")
  rm(list = ls(envir = envir_stacomi), envir = envir_stacomi)
	
})


test_that("test charge method", {
			skip_on_cran()
			stacomi(database_expected = TRUE, sch ="logrami")
			env_set_test_stacomi()
			r_mig_char <- choice_c(
					r_mig_char,
					dc = c(107, 108, 101),
					taxa = c("Salmo salar"),
					stage = c('5', '11', 'BEC', 'BER', 'IND'),
					parquan = c('A124', 'C001'),
					parqual = NULL,
					horodatedebut = "2012-01-01",
					horodatefin = "2012-12-31",
					echantillon= "with",
					silent = TRUE
			)
			expect_error(r_mig_char <- charge(r_mig_char), NA)						
			rm(list = ls(envir = envir_stacomi), envir = envir_stacomi)
			
		})

test_that("test plot xtable summary method", {
			skip_on_cran()
			stacomi(database_expected = TRUE, sch ="logrami")
			env_set_test_stacomi()
			r_mig_char <- choice_c(
					r_mig_char,
					dc = c(107, 108, 101),
					taxa = c("Salmo salar"),
					stage = c('5', '11', 'BEC', 'BER', 'IND'),
					parquan = c('A124', 'C001'),
					parqual = NULL,
					horodatedebut = "2012-01-01",
					horodatefin = "2012-12-31",
					silent = TRUE
			)
			r_mig_char <- connect(r_mig_char)
			r_mig_char <- calcule(r_mig_char, silent = TRUE)
      expect_error(suppressWarnings(plot(r_mig_char, plot.type = "quant", silent = TRUE)), NA)
			
			# now with a qualitative parm
			r_mig_char <- setasqualitative(
					r_mig_char,
					par = 'A124',
					silent = TRUE,
					breaks = c(0, 1.5, 2.5, 10),
					label = c("age 1", "age 2", "age 3")
			)
			r_mig_char <- calcule(r_mig_char, silent = TRUE)
			expect_error(suppressWarnings(plot(r_mig_char, plot.type = "quant", silent = TRUE)), NA)
			expect_error(suppressWarnings(plot(r_mig_char, plot.type = "crossed", silent = TRUE)), NA)
			expect_output(summary(r_mig_char))
			expect_error(xtable(r_mig_char), NA)
			rm(list = ls(envir = envir_stacomi), envir = envir_stacomi)
			
		})