% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R, R/subset.R
\name{st_crop}
\alias{st_crop}
\alias{st_crop.stars_proxy}
\alias{st_crop.stars}
\title{crop a stars object}
\usage{
\method{st_crop}{stars_proxy}(
  x,
  y,
  ...,
  crop = TRUE,
  epsilon = sqrt(.Machine$double.eps),
  collect = TRUE
)

\method{st_crop}{stars}(
  x,
  y,
  ...,
  crop = TRUE,
  epsilon = sqrt(.Machine$double.eps),
  as_points = all(st_dimension(y) == 2, na.rm = TRUE)
)
}
\arguments{
\item{x}{object of class \code{stars}}

\item{y}{object of class \code{sf}, \code{sfc} or \code{bbox}; see Details below.}

\item{...}{ignored}

\item{crop}{logical; if \code{TRUE}, the spatial extent of the returned object is cropped to still cover \code{obj}, if \code{FALSE}, the extent remains the same but cells outside \code{y} are given \code{NA} values.}

\item{epsilon}{numeric; factor to shrink the bounding box of \code{y} towards its center before cropping.}

\item{collect}{logical; if \code{TRUE}, repeat cropping on \code{stars} object, i.e. after data has been read}

\item{as_points}{logical; only relevant if \code{y} is of class \code{sf} or \code{sfc}: if \code{FALSE}, treat \code{x} as a set of points, else as a set of small polygons. Default: \code{TRUE} if \code{y} is two-dimensional, else \code{FALSE}; see Details}
}
\description{
crop a stars object
}
\details{
for raster \code{x}, \code{st_crop} selects cells that intersect with \code{y}. 
For intersection, are raster cells interpreted as points or as small polygons? 
If \code{y} is of class \code{stars}, \code{x} raster cells are interpreted as points; if \code{y} is of class \code{bbox}, \code{x} cells are interpreted as cells (small polygons). Otherwise, if \code{as_points} is not given, cells are interpreted as points if \code{y} has a two-dimensional geometry.
}
\examples{
l7 = read_stars(system.file("tif/L7_ETMs.tif", package = "stars"))
d = st_dimensions(l7)

# area around cells 3:10 (x) and 4:11 (y):
offset = c(d[["x"]]$offset, d[["y"]]$offset)
res = c(d[["x"]]$delta, d[["y"]]$delta)
bb = st_bbox(c(xmin = offset[1] + 2 * res[1],
	ymin = offset[2] + 11 * res[2],
	xmax = offset[1] + 10 * res[1],
	ymax = offset[2] +  3 * res[2]), crs = st_crs(l7))
l7[bb]

plot(l7[,1:13,1:13,1], reset = FALSE)
image(l7[bb,,,1], add = TRUE, col = sf.colors())
plot(st_as_sfc(bb), add = TRUE, border = 'green', lwd = 2)

# slightly smaller bbox:
bb = st_bbox(c(xmin = offset[1] + 2.1 * res[1],
	ymin = offset[2] + 10.9 * res[2],
	xmax = offset[1] +  9.9 * res[1],
	ymax = offset[2] +  3.1 * res[2]), crs = st_crs(l7))
l7[bb]

plot(l7[,1:13,1:13,1], reset = FALSE)
image(l7[bb,,,1], add = TRUE, col = sf.colors())
plot(st_as_sfc(bb), add = TRUE, border = 'green', lwd = 2)

# slightly larger bbox:
bb = st_bbox(c(xmin = offset[1] + 1.9 * res[1],
	ymin = offset[2] + 11.1 * res[2],
	xmax = offset[1] + 10.1 * res[1],
	ymax = offset[2] +  2.9 * res[2]), crs = st_crs(l7))
l7[bb]

plot(l7[,1:13,1:13,1], reset = FALSE)
image(l7[bb,,,1], add = TRUE, col = sf.colors())
plot(st_as_sfc(bb), add = TRUE, border = 'green', lwd = 2)

# half a cell size larger bbox:
bb = st_bbox(c(xmin = offset[1] + 1.49 * res[1],
	ymin = offset[2] + 11.51 * res[2],
	xmax = offset[1] + 10.51 * res[1],
	ymax = offset[2] +  2.49 * res[2]), crs = st_crs(l7))
l7[bb]

plot(l7[,1:13,1:13,1], reset = FALSE)
image(l7[bb,,,1], add = TRUE, col = sf.colors())
plot(st_as_sfc(bb), add = TRUE, border = 'green', lwd = 2)
}
