% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slope.R
\name{slope}
\alias{slope}
\title{Calculate topographic slope from a DEM}
\usage{
slope(x, na_flag = -9999)
}
\arguments{
\item{x}{A raster (class \code{stars}) with two dimensions: \code{x} and \code{y}, i.e., a single-band raster, representing a DEM.}

\item{na_flag}{Value used to mark \code{NA} values in C code. This should be set to a value which is guaranteed to be absent from the input raster \code{x} (default is \code{-9999}).}
}
\value{
A \code{stars} raster with topographic slope, i.e., the azimuth where the terrain is tilted towards, in decimal degrees (0-360) clockwise from north.
}
\description{
Calculates topographic slope given a Digital Elevation Model (DEM) raster. Input and output are rasters of class \code{stars}, single-band (i.e., only `"x"` and `"y"` dimensions), with one attribute.
}
\note{
Slope calculation results in \code{NA} when at least one of the cell neighbors is \code{NA}, including the outermost rows and columns. Given that the focal window size in slope calculation is 3*3, this means that the outermost one row and one column are given an slope value of \code{NA}.
}
\examples{
# Small example
data(dem)
slope = slope(dem)
r = c(dem, round(slope, 1), along = 3)
r = st_set_dimensions(r, 3, values = c("input", "slope"))
plot(r, text_values = TRUE, breaks = "equal", col = hcl.colors(11, "Spectral"))
\donttest{
# Larger example
data(carmel)
carmel_slope = slope(carmel)
r = c(carmel, round(carmel_slope, 1), along = 3)
r = st_set_dimensions(r, 3, values = c("input", "slope"))
plot(r, breaks = "equal", col = hcl.colors(11, "Spectral"))
}

}
\references{
The topographic slope algorithm is based on the \emph{How slope works} article in the ArcGIS documentation:

\url{https://desktop.arcgis.com/en/arcmap/10.3/tools/spatial-analyst-toolbox/how-slope-works.htm}
}
