% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_to_vector.R
\name{layer_to_vector}
\alias{layer_to_vector}
\title{Get \code{stars} layer values as vector}
\usage{
layer_to_vector(x, check = TRUE)
}
\arguments{
\item{x}{A raster (class \code{stars}) with two dimensions: \code{x} and \code{y}, i.e., a single-band raster.}

\item{check}{Whether to check (and fix if necessary) that input has one attribute, one layer and x-y as dimensions 1-2 (default is \code{TRUE}).}
}
\value{
A vector with cell values, ordered by rows, starting from the top left corner (north-west) and to the right.
}
\description{
Extracts the values of a single layer in a \code{stars} object to a vector. Cell values are ordered from top-left corner to the right.
}
\examples{
data(dem)
v = layer_to_vector(dem)
v

}
