% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateConf.R
\name{simConf}
\alias{simConf}
\title{Simulate data  according to a static model of confidence}
\usage{
simConf(model = "SDT", paramDf)
}
\arguments{
\item{model}{\code{character} of length 1.
Models implemented so far: 'WEV', 'SDT', 'GN', 'PDA', 'IG', 'ITGc', 'ITGcm', 'logN', and 'logWEV'.}

\item{paramDf}{a \code{data.frame} that contains all parameters to simulate a data set,
with one row and the different parameters in different columns. Which parameters are needed depends on the specific model:
\itemize{
\item \code{N} (the number of trials be simulated),
\item \code{participant} (optional, the participant ID of each parameter set. Should be unique to each row),
\item \code{d_1}, \code{d_2}, ... (sensitivity parameters. The number of sensitivity parameters determines the number of levels of discriminability),
\item \code{c} (discrimination bias),
\item \code{theta_minus.1}, \code{theta_minus.2}, ... (confidence criteria associated with the response R = -1. The function simulates one more confidence category than there are confidence criteria),
\item \code{theta_plus.1}, \code{theta_plus.2}, ... (confidence criteria associated with the response R = 1. The function simulates one more confidence category than there are confidence criteria),
\item \code{w} (only for models WEV and logWEV: the visibility weighting parameter, bounded between 0 and 1),
\item \code{sigma} (only for models WEV, GN, logN, and logWEV: confidence noise, bounded between 0 and Inf),
\item \code{m} (only for IG, ITGm, and ITGcm: metacognitive efficiency parameter, bounded between 0 and Inf),
\item \code{b} (only for PDA: postdecisional accumulation parameter, bounded between 0 and Inf),
\item \code{M_theta_minus.1}, \code{M_theta_minus.2}, ... (only for logN: Mean confidence criteria associated with the response R = -1),
\item \code{M_theta_plus.1}, \code{M_theta_plus.2},... (only for logN: Mean confidence criteria associated with the response R = 1).
}}
}
\value{
a dataframe with \code{N} rows, and the columns
\code{stimulus}, \code{correct} and \code{rating}. If more than 1 sensitivity parameter is provided, there is
\code{diffCond}.
}
\description{
Simulate data  according to a static model of confidence
}
\details{
see \code{fitConf} for a detailed description of the different models.
}
\examples{
# 1. define some parameters
paramDf <- data.frame(d_1 = 0, d_2 = 2, d_3 = 4,c = .0,
theta_minus.2 = -2, theta_minus.1 = -1, theta_plus.1 = 1, theta_plus.2 = 2,
sigma = 1/2, w = 0.5, N = 500)
# 2. Simulate dataset
SimulatedData <- simConf(model = "WEV", paramDf)

}
\author{
Manuel Rausch, \email{manuel.rausch@hochschule-rhein-waal.de}
}
