% Generated by roxygen2 (4.0.2): do not edit by hand
\name{duplicates}
\alias{duplicates}
\alias{duplicates_}
\title{returns duplicated rows}
\usage{
duplicates(x, ..., by = NULL, gen = "N")

duplicates_(x, vars, by = NULL, gen = "N")
}
\arguments{
\item{x}{a data.table}

\item{...}{Variables to keep (beyond the by variable). Default to all variables. See the \link[dplyr]{select} documentation.}

\item{by}{Variable to group by. Default is the key, or everything is the data.table is not keyed.}

\item{gen}{A character that specifies  the name of a new variable with the number of duplicates. Default to "N".}

\item{vars}{Used to work around non-standard evaluation.}
}
\value{
a data.table with groups that have duplicates.
}
\description{
returns duplicated rows
}
\examples{
library(data.table)
DT <- data.table(a = rep(1:2, each = 3), b = 1:6)
duplicates(DT, by = "a")
duplicates(DT, by = list(a,b))
}

