% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-missing.R
\name{plot_missing}
\alias{plot_missing}
\alias{missing_info}
\title{Vizualize missing and non-proper cases for state panel data}
\usage{
plot_missing(x, data, space, time, time_unit, statelist = c("none", "GW",
  "COW"))

missing_info(x, data, space, time, time_unit, statelist = "none")
}
\arguments{
\item{x}{Variable names(s), e.g. "x" or c("x1", "x2").}

\item{data}{State panel data frame}

\item{space}{Name of state identifier}

\item{time}{Name of time identifier}

\item{time_unit}{Temporal resolution character string, e.g. "year" or "month".
See details in \code{\link[base]{seq.Date}}.}

\item{statelist}{Check not only missing values, but presence or absence of
observations against a list of independent states? "none" or "GW" or "COW".}
}
\description{
Plot missing values by country and date, and additionally identify country-date
cases that do or do not match an independent state list.
}
\details{
\code{missing_info} provides the information that is plotted with
    \code{plot_missing}. The latter returns a ggplot, and thus can be chained
    with other ggplot functions as usual.
}
\examples{
cy <- state_panel(as.Date("1980-06-30"), as.Date("2015-06-30"), by = "year",
useGW = TRUE)
cy$myvar <- rnorm(nrow(cy))
cy$myvar[sample(1:nrow(cy), nrow(cy)*.1, replace = FALSE)] <- NA
str(cy)

head(missing_info("myvar", cy, "gwcode", "date", "year", "none"))
plot_missing("myvar", cy, "gwcode", "date", "year", "none")

# Check data also against G&W list of independent states
head(missing_info("myvar", cy, "gwcode", "date", "year", "GW"))
plot_missing("myvar", cy, "gwcode", "date", "year", "GW")

# To check all variables:
# plot_missing(setdiff(colnames(df), "space", "time"), ...)
}
