/*
 * Decompiled with CFR 0.152.
 */
package imp;

import blbutil.FloatList;
import imp.ImpData;
import imp.ImputedRecBuilder;
import imp.RefHapHash;
import imp.StateProbs;
import ints.IntList;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.IntStream;
import vcf.MarkerIndices;
import vcf.Markers;
import vcf.RefGT;
import vcf.Samples;

public class ImputedVcfWriter {
    private final ImpData impData;
    private final Samples targSamples;
    private final int targCluster;
    private final int refStart;
    private final int clustEnd;
    private final int refEnd;
    private final IntList indices = new IntList(4);
    private final IntList hashes = new IntList(4);
    private final FloatList seqProbs = new FloatList(4);
    private final FloatList seqProbsP1 = new FloatList(4);

    public ImputedVcfWriter(ImpData impData, int n, int n2, int n3) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (n2 > impData.refGT().nMarkers()) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        this.impData = impData;
        this.targSamples = impData.targSamples();
        this.targCluster = n3;
        this.refStart = n3 == 0 ? n : Math.max(n, impData.refClusterStart(n3));
        if (n3 < impData.nClusters() - 1) {
            int n4 = Math.max(n, impData.refClusterEnd(n3));
            this.clustEnd = Math.min(n4, n2);
            this.refEnd = Math.min(impData.refClusterStart(n3 + 1), n2);
        } else {
            this.clustEnd = n2;
            this.refEnd = n2;
        }
    }

    public void appendRecords(AtomicReferenceArray<StateProbs> atomicReferenceArray, PrintWriter printWriter) {
        int n;
        if (this.refStart >= this.refEnd) {
            return;
        }
        RefHapHash refHapHash = new RefHapHash(atomicReferenceArray, this.targCluster, this.impData.refGT(), this.refStart, this.refEnd);
        ImputedRecBuilder[] imputedRecBuilderArray = this.recBuilders();
        float[][] fArray = this.alProbs();
        float[][] fArray2 = this.alProbs();
        boolean[] blArray = this.isImputed();
        int n2 = atomicReferenceArray.length();
        for (n = 0; n < n2; n += 2) {
            int n3;
            boolean bl = this.targSamples.isDiploid(n >> 1);
            this.setAlProbs(atomicReferenceArray.get(n), refHapHash, fArray);
            this.setAlProbs(atomicReferenceArray.get(n + 1), refHapHash, fArray2);
            if (bl) {
                for (n3 = 0; n3 < fArray.length; ++n3) {
                    if (!blArray[n3]) {
                        this.setToObsAlleles(fArray, fArray2, n3, n);
                    }
                    imputedRecBuilderArray[n3].addSampleData(fArray[n3], fArray2[n3]);
                    Arrays.fill(fArray[n3], 0.0f);
                    Arrays.fill(fArray2[n3], 0.0f);
                }
                continue;
            }
            for (n3 = 0; n3 < fArray.length; ++n3) {
                if (!blArray[n3]) {
                    this.setToObsAlleles(fArray, fArray2, n3, n);
                }
                imputedRecBuilderArray[n3].addSampleData(fArray[n3]);
                Arrays.fill(fArray[n3], 0.0f);
                Arrays.fill(fArray2[n3], 0.0f);
            }
        }
        for (n = 0; n < fArray.length; ++n) {
            imputedRecBuilderArray[n].printRec(printWriter, blArray[n]);
        }
    }

    private void setAlProbs(StateProbs stateProbs, RefHapHash refHapHash, float[][] fArray) {
        ImputedVcfWriter.clearLists(this.indices, this.hashes, this.seqProbs, this.seqProbsP1);
        int[] nArray = new int[refHapHash.end() - refHapHash.start()];
        int n = stateProbs.nStates(this.targCluster);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = stateProbs.refHap(this.targCluster, i);
            float f = stateProbs.probs(this.targCluster, i);
            float f2 = stateProbs.probsP1(this.targCluster, i);
            int n4 = refHapHash.hap2Index(n3);
            int n5 = refHapHash.hash(n4);
            for (n2 = 0; n2 < this.hashes.size() && this.hashes.get(n2) != n5; ++n2) {
            }
            if (n2 == this.hashes.size()) {
                this.indices.add(n4);
                this.hashes.add(n5);
                this.seqProbs.add(f);
                this.seqProbsP1.add(f2);
                continue;
            }
            this.seqProbs.addToElement(n2, f);
            this.seqProbsP1.addToElement(n2, f2);
        }
        this.setAlProbs(fArray, refHapHash, nArray);
    }

    private void setAlProbs(float[][] fArray, RefHapHash refHapHash, int[] nArray) {
        int n = this.seqProbs.size();
        if (n == 1) {
            int n2 = this.indices.get(0);
            refHapHash.setAlleles(n2, nArray);
            for (int i = this.refStart; i < this.refEnd; ++i) {
                int n3 = i - this.refStart;
                fArray[n3][nArray[n3]] = 1.0f;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n4;
                int n5 = this.indices.get(i);
                refHapHash.setAlleles(n5, nArray);
                float f = this.seqProbs.get(i);
                float f2 = this.seqProbsP1.get(i);
                for (n4 = this.refStart; n4 < this.clustEnd; ++n4) {
                    int n6 = n4 - this.refStart;
                    float[] fArray2 = fArray[n6];
                    int n7 = nArray[n6];
                    fArray2[n7] = fArray2[n7] + f;
                }
                for (n4 = this.clustEnd; n4 < this.refEnd; ++n4) {
                    double d = this.impData.weight(n4);
                    int n8 = n4 - this.refStart;
                    float[] fArray3 = fArray[n8];
                    int n9 = nArray[n8];
                    fArray3[n9] = (float)((double)fArray3[n9] + (d * (double)f + (1.0 - d) * (double)f2));
                }
            }
        }
    }

    private void setToObsAlleles(float[][] fArray, float[][] fArray2, int n, int n2) {
        Arrays.fill(fArray[n], 0.0f);
        Arrays.fill(fArray2[n], 0.0f);
        int n3 = this.impData.markerIndices().markerToTargMarker(this.refStart + n);
        int n4 = this.impData.targGT().allele(n3, n2);
        int n5 = this.impData.targGT().allele(n3, n2 + 1);
        fArray[n][n4] = 1.0f;
        fArray2[n][n5] = 1.0f;
    }

    private ImputedRecBuilder[] recBuilders() {
        RefGT refGT = this.impData.refGT();
        boolean bl = this.impData.par().gp();
        boolean bl2 = this.impData.par().ap();
        int n = this.impData.nInputTargHaps();
        return (ImputedRecBuilder[])IntStream.range(this.refStart, this.refEnd).mapToObj(n2 -> new ImputedRecBuilder(refGT.marker(n2), n, bl2, bl)).toArray(ImputedRecBuilder[]::new);
    }

    private float[][] alProbs() {
        Markers markers = this.impData.refGT().markers();
        return (float[][])IntStream.range(this.refStart, this.refEnd).mapToObj(n -> new float[markers.marker(n).nAlleles()]).toArray(n -> new float[n][]);
    }

    private boolean[] isImputed() {
        MarkerIndices markerIndices = this.impData.markerIndices();
        boolean[] blArray = new boolean[this.refEnd - this.refStart];
        for (int i = 0; i < blArray.length; ++i) {
            if (markerIndices.markerToTargMarker(this.refStart + i) != -1) continue;
            blArray[i] = true;
        }
        return blArray;
    }

    private static void clearLists(IntList intList, IntList intList2, FloatList floatList, FloatList floatList2) {
        intList.clear();
        intList2.clear();
        floatList.clear();
        floatList2.clear();
    }
}

