% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createVarComp.R
\name{plot.varComp}
\alias{plot.varComp}
\title{Plot function for class varComp}
\usage{
\method{plot}{varComp}(x, ..., plotType = c("sd", "percVar"), title = NULL, output = TRUE)
}
\arguments{
\item{x}{An object of class varComp}

\item{...}{Not used.}

\item{plotType}{A character string. Either "sd" to plot the standard
deviation of the variance components, or "percVar" to plot the percentage of
variance explained by each variance component.}

\item{title}{A character string used a title for the plot.}

\item{output}{Should the plot be output to the current device? If
\code{FALSE} only a ggplot object is invisibly returned.}
}
\value{
A ggplot object is invisibly returned.
}
\description{
A plot is created of either the standard deviations of each of the terms in
the fitted model or the percentage of variance explained by each of the
terms in the fitted model. Also the degrees of freedom for each of the
terms is shown in the plot.
}
\examples{
## Fit a mixed model.
geVarComp <- gxeVarComp(TD = TDMaize, trait = "yld")

## Plot the standard deviations.
plot(geVarComp)
## Plot the percentage of variance explained.
plot(geVarComp, plotType = "percVar")

}
\seealso{
Other Mixed model analysis: 
\code{\link{CRDR}()},
\code{\link{correlations}()},
\code{\link{diagnostics}()},
\code{\link{gxeVarComp}()},
\code{\link{herit}()},
\code{\link{predict.varComp}()},
\code{\link{vc}()}
}
\concept{Mixed model analysis}
