% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gxeStability.R
\name{gxeStability}
\alias{gxeStability}
\title{Calculate stability coefficients for genotype-by-environment data}
\usage{
gxeStability(
  TD,
  trials = names(TD),
  trait,
  method = c("superiority", "static", "wricke"),
  bestMethod = c("max", "min"),
  sorted = c("descending", "ascending", "none")
)
}
\arguments{
\item{TD}{An object of class \code{\link{TD}}.}

\item{trials}{A character string specifying the trials to be analyzed. If
not supplied, all trials are used in the analysis.}

\item{trait}{A character string specifying the trait to be analyzed.}

\item{method}{A character vector specifying the measures of stability to be
calculated. Options are "superiority" (cultivar-superiority measure),
"static" (Shukla's stability variance) or "wricke" (wricke's ecovalence).}

\item{bestMethod}{A character string specifying the criterion to define
the best genotype. Either \code{"max"} or \code{"min"}.}

\item{sorted}{A character string specifying the sorting order of the results.}
}
\value{
An object of class \code{\link{stability}}, a list containing:
\item{superiority}{A data.frame containing values for the
cultivar-superiority measure of Lin and Binns.}
\item{static}{A data.frame containing values for Shukla's stability
variance.}
\item{wricke}{A data.frame containing values for Wricke's ecovalence.}
\item{trait}{A character string indicating the trait that has been analyzed.}
}
\description{
This function calculates different measures of stability, the
cultivar-superiority measure of Lin & Binns (1988), Shukla's (1972) stability
variance and Wricke's (1962) ecovalence.
}
\examples{
## Compute three stability measures for TDMaize.
geStab <- gxeStability(TD = TDMaize, trait = "yld")

## Summarize results.
summary(geStab)

## Create plot of the computed stability measures against the means.
plot(geStab)

\donttest{
## Create a .pdf report summarizing the stability measures.
report(geStab, outfile = tempfile(fileext = ".pdf"))
}

## Compute Wricke's ecovalance for TDMaize with minimal values for yield as
## the best values. Sort results in ascending order.
geStab2 <- gxeStability(TD = TDMaize, trait = "yld", method = "wricke",
                       bestMethod = "min", sorted = "ascending")
summary(geStab2)

}
\references{
Lin, C. S. and Binns, M. R. 1988. A superiority measure of
cultivar performance for cultivar x location data. Can. J. Plant Sci. 68:
193-198

Shukla, G.K. 1972. Some statistical aspects of partitioning
genotype-environmental components of variability. Heredity 29:237-245

Wricke, G. Uber eine method zur erfassung der okologischen
streubreit in feldversuchen. Zeitschrift für Pflanzenzucht,
v. 47, p. 92-96, 1962
}
\seealso{
Other stability: 
\code{\link{plot.stability}()},
\code{\link{report.stability}()}
}
\concept{stability}
