% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LLQuadFormDiagCPP}
\alias{LLQuadFormDiagCPP}
\title{Compute tYPY as in Zhou and Stephens eqn. 50.}
\usage{
LLQuadFormDiagCPP(y, vInv, size_param_x = NULL)
}
\arguments{
\item{y}{An n x p matrix of observed phenotypes, on p traits or environments
for n genotypes. No missing values are allowed.}

\item{vInv}{A n x p x p cube containing for each genotype l the
p x p matrix \eqn{v_l ^ {-1}} (in the notation of Zhou and Stephens).}

\item{size_param_x}{An optional c x n covariate matrix, c being the number
of covariates and n being the number of genotypes. c has to be at least one
(typically an intercept). No missing values are allowed.}
}
\value{
A numerical value for the \eqn{t(y) * P * y} part of the
log-likelihood function.
}
\description{
Compute \eqn{t(y) * P * y}, part of the log-likelihood functions from
equation 26 and 27 in Zhou and Stephens using equation 50. Equation 56, 57
and 58 are used to do the actual computations.
}
\details{
It is assumed that X and Y have already been rotated by Uk, where Uk is such
that the kinship matrix K equals \eqn{K = Uk * Dk * t(Uk)}.\cr
The original X and Y are right multiplied by Uk, e.g. \code{Y <- Y * Uk}.
See Zhou and Stephens (2014), supplement.\cr
It is these rotated versions that are the input of this function.
}
\references{
Zhou, X. and Stephens, M. (2014). Efficient multivariate linear
mixed model algorithms for genome-wide association studies. Nature Methods,
February 2014, Vol. 11, p. 407–409
}
\keyword{internal}
