% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers.R
\name{outlierSTA}
\alias{outlierSTA}
\title{Identifying outliers in objects of class STA}
\usage{
outlierSTA(
  STA,
  trials = NULL,
  traits = NULL,
  what = NULL,
  rLimit = NULL,
  commonFactors = NULL,
  verbose = TRUE
)
}
\arguments{
\item{STA}{An object of class \code{STA}.}

\item{trials}{A character vector specifying the trials for which outliers
should be identified. If \code{trials = NULL}, all trials are included.}

\item{traits}{A character vector specifying the traits for which outliers
should be identified.}

\item{what}{A character string indicating whether the outliers should be
identified for the fitted model with genotype as fixed
(\code{what = "fixed"}) or genotype as random (\code{what = "random"}) factor.
If \code{STA} contains only one model this model is chosen automatically.}

\item{rLimit}{A numerical value used for determining when a value is
considered an outlier. All observations with standardized residuals
exceeding \code{rLimit} will be marked as outliers.}

\item{commonFactors}{A character vector specifying the names of columns
in \code{TD} used for selecting observations that are similar to the
outliers. If \code{commonFactors = NULL}, only outliers are reported and
no similar observations.}

\item{verbose}{Should the outliers be printed to the console?}
}
\value{
A list with two components:
\itemize{
\item{indicator - a list of numeric vectors indicating the location of the
outliers in the data}
\item{outliers - a data.frame containing the outliers and observations
similar to the outliers as defined by \code{commonFactors}}
}
}
\description{
Function to identify observations with standardized residuals exceeding
\code{rLimit}. If not provided \code{rLimit} is computed as
\code{qnorm(1 - 0.5 / rDf)} where \code{rDf} is the residual degrees
of freedom for the model. This value is then restricted to the interval
2..4. Alternatively a custom limit may be provided.\cr
If \code{verbose = TRUE} a summary is printed of outliers and observations
that have the same value for \code{commonFactors}. The column outlier in the
output can be used to distinguish real outliers from observations included
because of their commonFactors.
}
\examples{
## Fit a model using lme4.
myModel <- fitTD(TD = TDHeat05, traits = "yield", design = "res.rowcol",
                engine = "lme4")

## Detect outliers in the standardized residuals of the fitted model.
outliers <- outlierSTA(STA = myModel, traits = "yield")

}
