% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.test.mean2}
\alias{size.test.mean2}
\title{Sample size for a test of a 2-group mean difference}
\usage{
size.test.mean2(alpha, pow, var, es, R)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{var}{planning value of average within-group variance}

\item{es}{planning value of mean difference}

\item{R}{n2/n1 ratio}
}
\value{
Returns the required sample size per group
}
\description{
Computes the sample size in each group required  to test a difference in
population means with desired power in a 2-group design. Set R =1 for equal
sample sizes. Set the variance planning value to the largest value within a
plausible range for a conservatively large sample size.
}
\examples{
size.test.mean2(.05, .95, 100, 10, 1) 

# Should return:
#      n1  n2
# [1,] 27  27
 

}
