% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.lc.stdmean.bs}
\alias{ci.lc.stdmean.bs}
\title{Confidence interval for a standardized linear contrast of means in a
between-subjects design}
\usage{
ci.lc.stdmean.bs(alpha, m, sd, n, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m}{vector of estimated group means}

\item{sd}{vector of estimated group standard deviation}

\item{n}{vector of sample sizes}

\item{v}{vector of between-subjects contrast coefficients}
}
\value{
Returns a 3-row matrix. The columns are:
\itemize{
\item Estimate - estimated standardized linear contrast
\item adj Estimate - bias adjusted standardized linear contrast estimate
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals for a population standardized linear contrast
of means in a between-subjects design. The unweighted standardizer is
recommended in experimental designs. The weighted standardizer is
recommended in nonexperimental designs with simple random sampling. The
group 1 standardizer is useful in both experimental and nonexperimental
designs. Equality of variances is not assumed.
}
\examples{
m <- c(33.5, 37.9, 38.0, 44.1)
sd <- c(3.84, 3.84, 3.65, 4.98)
n <- c(10,10,10,10)
v <- c(.5, .5, -.5, -.5)
ci.lc.stdmean.bs(.05, m, sd, n, v)

# Should return:
#                           Estimate  adj Estimate        SE        LL         UL
# Unweighted standardizer: -1.301263     -1.273964 0.3692800 -2.025039 -0.5774878
# Weighted standardizer:   -1.301263     -1.273964 0.3514511 -1.990095 -0.6124317
# Group 1 standardizer:    -1.393229     -1.273810 0.4849842 -2.343781 -0.4426775


}
\references{
\insertRef{Bonett2008}{statpsych}
}
