% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.ci.prop.prior}
\alias{size.ci.prop.prior}
\title{Sample size for a proportion confidence interval using a planning value
from a prior study}
\usage{
size.ci.prop.prior(alpha1, alpha2, p0, n0, w)
}
\arguments{
\item{alpha1}{alpha level for 1-alpha1 confidence in the planned study}

\item{alpha2}{alpha level for the 1-alpha2 prediction interval}

\item{p0}{estimated proportion in prior study}

\item{n0}{sample size in prior study}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a population proportion with
desired confidence interval precision in applications where an estimated
proportion from a prior study is available. The actual confidence interval
width in the planned study will depend on the value of the estimated
proportion in the planned study. An estimated proportion from a prior study
is used to predict the value of the estimated proportion in the planned
study, and the predicted proportion estimate is then used in the sample size
computation.

This sample size approach assumes that the population proportion in the
prior study is very similar to the population proportion in the planned
study. In a typical sample size analysis, this type of information is not
available, and the researcher must use expert opinion to guess the value of
the proportion that will be observed in the planned study. The
\link[statpsych]{size.ci.prop}) function uses a proportion planning value
that is based on expert opinion regarding the likely value of the proportion
estimate that will be observed in the planned study.
}
\examples{
size.ci.prop.prior(.05, .20, .1425, 200, .1)

# Should return:
# Sample size
#         318


}
