% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixer_functions.R
\name{fix_time}
\alias{fix_time}
\title{Fixes the time column of a data set}
\usage{
fix_time(df)
}
\arguments{
\item{df}{a table with a time column from Statistics Denmark. Usually retrieved
using the \link{retrieve_data} function.}
}
\value{
a data frame
}
\description{
Statistics Denmark data often come with times/dates that are formatted to
fit months or quarters. This function converts them in to proper date strings
in the format YYYY-MM-DD.
}
\examples{
df <- statsDK::retrieve_data("FOLK1A", TID = "*")
dplyr::glimpse(df)

df <-  statsDK::fix_time(df)
dplyr::glimpse(df)

}
