% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_anova.R
\name{expr_anova_nonparametric}
\alias{expr_anova_nonparametric}
\title{Making text expression for non-parametric ANOVA.}
\usage{
expr_anova_nonparametric(
  data,
  x,
  y,
  subject.id = NULL,
  paired = FALSE,
  k = 2L,
  conf.level = 0.95,
  conf.type = "perc",
  nboot = 100L,
  output = "expression",
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{subject.id}{In case of repeated measures design (\code{paired = TRUE},
i.e.), this argument specifies the subject or repeated measures id. Note
that if this argument is \code{NULL} (which is the default), the function
assumes that the data has already been sorted by such an id by the user and
creates an internal identifier. So if your data is \strong{not} sorted and you
leave this argument unspecified, the results can be inaccurate.}

\item{paired}{Decides whether the design is repeated measures or not
(Default: \code{FALSE}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} confidence/credible intervals (\code{0.95}).}

\item{conf.type}{A vector of character strings representing the type of
intervals required. The value should be any subset of the values \code{"norm"},
\code{"basic"}, \code{"perc"}, \code{"bca"}. For more, see \code{?boot::boot.ci}.}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{output}{If \code{"expression"}, will return expression with statistical
details, while \code{"dataframe"} will return a dataframe containing the
results.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
\description{
Making text expression for non-parametric ANOVA.
}
\details{
For paired designs, the effect size is Kendall's coefficient of
concordance (\emph{W}), while for between-subjects designs, the effect size is
epsilon-squared (for more, see \code{?rcompanion::epsilonSquared} and
\code{?rcompanion::kendallW}).
}
\examples{
# setup
set.seed(123)
library(statsExpressions)

# -------------- within-subjects design --------------------------------

# creating the expression
expr_anova_nonparametric(
  data = bugs_long,
  x = condition,
  y = desire,
  paired = TRUE,
  conf.level = 0.99,
  k = 2
)

# -------------- between-subjects design --------------------------------

expr_anova_nonparametric(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem,
  paired = FALSE,
  conf.level = 0.99,
  conf.type = "perc"
)
}
