% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mig_stoch_crm.r
\name{mig_stoch_crm}
\alias{mig_stoch_crm}
\title{Stochastic migration collision risk model}
\usage{
mig_stoch_crm(
  wing_span_pars,
  flt_speed_pars,
  body_lt_pars,
  prop_crh_pars,
  avoid_bsc_pars,
  n_turbines,
  n_blades = 3,
  rtn_speed_pars,
  bld_pitch_pars,
  rtr_radius_pars,
  bld_width_pars,
  wf_width,
  wf_latitude,
  flight_type,
  prop_upwind = 0.5,
  popn_estim_pars,
  season_specs,
  chord_profile = chord_prof_5MW,
  trb_wind_avbl,
  trb_downtime_pars,
  n_iter = 10,
  LargeArrayCorrection = TRUE,
  log_file = NULL,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{wing_span_pars}{A single row data frame with columns \code{mean} and \code{sd},
the mean and standard deviation of the species wingspan, in metres. Assumed
to follow a \emph{tnorm-lw0} distribution.}

\item{flt_speed_pars}{A single row data frame with columns \code{mean} and \code{sd},
the mean and standard deviation of the species flying speed, in metres/sec.
Assumed to follow a Truncated Normal with lower bound at 0 (\emph{tnorm-lw0}).}

\item{body_lt_pars}{A single row data frame with columns \code{mean} and \code{sd}, the
mean and standard deviation of the species body length, in metres. Assumed
to follow a \emph{tnorm-lw0} distribution.}

\item{prop_crh_pars}{A single row data frame with columns \code{mean} and \code{sd}.
The mean and standard deviation of the proportion of flights at
collision risk height.}

\item{avoid_bsc_pars}{Single row data frame with columns
\code{mean} and \code{sd}, the mean and standard deviation of the species avoidance
rate to be used. Avoidance rate expresses the probability that a bird
flying on a collision course with a turbine will take evading action
to avoid collision, and it is assumed to follow a Beta distribution.}

\item{n_turbines}{An integer. The number of turbines expected to be installed}

\item{n_blades}{An integer. The number of blades per turbine (defaults to 3)}

\item{rtn_speed_pars}{A single row data frame with columns \code{mean} and \code{sd},
the mean and standard deviation of the rotation speed.}

\item{bld_pitch_pars}{A single row data frame with columns \code{mean} and \code{sd},
the mean and standard deviation of the blade pitch angle,
i.e. the angle between the blade surface and the rotor plane,
in degrees. Assumed to follow a \emph{tnorm-lw0} distribution.}

\item{rtr_radius_pars}{A single row data frame with columns \code{mean} and \code{sd},
the mean and standard deviation of the radius of the rotor, in metres.
Assumed to follow a \emph{tnorm-lw0} distribution.}

\item{bld_width_pars}{A single row data frame with columns \code{mean} and \code{sd},
the mean and standard deviation of the maximum blade width, in metres.
Assumed to be \emph{tnorm-lw0} distribution.}

\item{wf_width}{Numeric value, the approximate longitudinal width of the
wind farm, in kilometres (\eqn{w}).}

\item{wf_latitude}{A decimal value. The latitude of the centroid of the
windfarm, in degrees.}

\item{flight_type}{A character. Either "flying" or "gliding" representing
the type of flight most commonly used by the species}

\item{prop_upwind}{Numeric value between 0-1 giving the proportion of
flights upwind - defaults to 0.5.}

\item{popn_estim_pars}{A single row data frame with columns \code{mean} and \code{sd}.
The population estimate of the species expected to fly through the wind farm
area.}

\item{season_specs}{A data frame
defining the seasons for aggregating over collision estimates. It must
comprise the following columns:
\itemize{
\item \code{season_id}, (unique) season identifier,
\item \code{start_month}, name of the season's first month,
\item \code{end_month}, name of the season's last month.
}}

\item{chord_profile}{A data frame with the chord taper profile of the rotor
blade. It must contain the columns:
\itemize{
\item \code{pp_radius}, equidistant intervals of radius at bird passage point,
as a proportion of \code{rotor_radius}, within the range \eqn{[0, 1]}.
\item \code{chord}, the chord width at \code{pp_radius}, as a proportion of \code{blade_width}.
Defaults to a generic profile for a typical modern 5MW turbine. See
\code{\link[=chord_prof_5MW]{chord_prof_5MW()}} for details.
}}

\item{trb_wind_avbl}{A data frame with the monthly estimates of operational
wind availability. It must contain the columns:
\itemize{
\item \code{month}, (unique) month names,
\item \code{pctg}, the percentage of time wind conditions allow for turbine operation
per month.
}}

\item{trb_downtime_pars}{A data frame with monthly estimates of maintenance
downtime, assumed to follow a \emph{tnorm-lw0} distribution. It
must contain the following columns:
\itemize{
\item \code{month}, (unique) month names,
\item \code{mean}, numeric, the mean percentage of time in each month when turbines
are not operating due to maintenance,
\item \code{sd}, the standard deviation of monthly maintenance downtime.
}}

\item{n_iter}{An integer > 0. The number of iterations for the model simulation.}

\item{LargeArrayCorrection}{A boolean. Should the large array correction be calculated}

\item{log_file}{Path to log file to store session info and main model run
options. If set to NULL (default value), log file is not created.}

\item{seed}{Integer, the random seed for \link[base:Random]{random number generation}, for analysis reproducibility.}

\item{verbose}{boolean. TRUE for a verbose output}
}
\value{
Estimates of number of collisions per migratory season for the n
number of iterations specified
}
\description{
Run migration stochastic collision risk model for a single species and one turbine scenario
}
\details{
This function is an adaption of code from Masden(2015) used for estimating
the collision risk of seabirds in offshore windfarm sites and is a further
adaptation from Band(2012). It is a further adaptation of the stoch_crm function.

The collision risk model evaluates risk for each defined migratory period where
flux rate is simply the number of birds travelling through the windfarm.

Changes in relation to previous top-line function \code{stoch_crm}
\itemize{
\item function will run only option 1 for migratory species
}
}
\examples{
# ------------------------------------------------------
# Run with arbitrary parameter values, for illustration
# ------------------------------------------------------
season_specs <- data.frame(
  season_id = c("PrBMigration", "PoBMigration","OMigration"),
  start_month = c("Mar", "May", "Oct"), end_month = c("Apr", "Sep", "Feb")
)

# wind availability
windavb <- data.frame(
  month = month.abb,
  pctg = runif(12, 85, 98)
)
head(windavb)

# maintenance downtime
dwntm <- data.frame(
  month = month.abb,
  mean = runif(12, 6, 10),
  sd = rep(2, 12))
head(dwntm)


mig_stoch_crm(
  # Wing span in m,
  wing_span_pars = data.frame(mean = 1.08, sd = 0.04),
  # Flight speed in m/s
  flt_speed_pars = data.frame(mean = 7.26, sd = 1.5),
  # Body length in m,
  body_lt_pars = data.frame(mean = 0.39, sd = 0.005),
  # Proportion of birds at CRH
  prop_crh_pars = data.frame(mean = 0.06, sd = 0.009),
  # avoidance rate
  avoid_bsc_pars = data.frame(mean = 0.99, sd = 0.001),
  n_turbines = 150,
  n_blades = 3,
  # rotation speed in m/s of turbine blades
  rtn_speed_pars = data.frame(mean = 13.1, sd = 4),
  # pitch in degrees of turbine blades
  bld_pitch_pars = data.frame(mean = 3, sd = 0.3),
  # sd = 0, rotor radius is fixed
  rtr_radius_pars = data.frame(mean = 80, sd = 0),
  # sd = 0, blade width is fixed
  bld_width_pars = data.frame(mean = 8, sd = 0),
  wf_width = 100,
  wf_latitude = 54.1,
  prop_upwind = 0.5,
  flight_type = "flapping",
  # population flying through windfarm,
  popn_estim_pars = data.frame(mean = 21584, sd = 2023),
  season_specs = season_specs,
  chord_profile = chord_prof_5MW,
  trb_wind_avbl = windavb,
  trb_downtime_pars = dwntm,
  n_iter = 1000,
  LargeArrayCorrection = TRUE,
  log_file = NULL,
  seed = 1234,
  verbose = TRUE)
}
