% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop_cmdscale.R
\name{stop_cmdscale}
\alias{stop_cmdscale}
\title{STOPS version of strain}
\usage{
stop_cmdscale(
  dis,
  theta = 1,
  type = "ratio",
  weightmat = NULL,
  ndim = 2,
  init = NULL,
  ...,
  stressweight = 1,
  structures = c("cclusteredness", "clinearity", "cdependence", "cmanifoldness",
    "cassociation", "cnonmonotonicity", "cfunctionality", "ccomplexity", "cfaithfulness",
    "cregularity", "chierarchy", "cconvexity", "cstriatedness", "coutlying",
    "cskinniness", "csparsity", "cstringiness", "cclumpiness", "cinequality"),
  strucweight = rep(1/length(structures), length(structures)),
  strucpars,
  verbose = 0,
  stoptype = c("additive", "multiplicative"),
  itmaxi = 1000,
  add = TRUE
)
}
\arguments{
\item{dis}{numeric matrix or dist object of a matrix of proximities}

\item{theta}{the theta vector of powers; this must be a scalar of the lambda transformation for the observed proximities.}

\item{type}{MDS type. Ignored here.}

\item{weightmat}{(optional) a matrix of nonnegative weights. Not used.}

\item{ndim}{number of dimensions of the target space}

\item{init}{(optional) initial configuration}

\item{...}{additional arguments to be passed to the fitting procedure}

\item{stressweight}{weight to be used for the fit measure; defaults to 1}

\item{structures}{which structuredness indices to be included in the loss}

\item{strucweight}{weight to be used for the structuredness indices; ; defaults to 1/#number of structures}

\item{strucpars}{the parameters for the structuredness indices}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is extremely verbose}

\item{stoptype}{How to construct the target function for the multi objective optimization? Either 'additive' (default) or 'multiplicative'}

\item{itmaxi}{number of iterations. No effect here.}

\item{add}{if TRUE dis is made to Euclidean disatnces}
}
\value{
A list with the components
   \itemize{
        \item{stress:} the badness-of-fit value (this isn't stress here but 1-(sum_ndim(max(eigenvalues,0))/sum_n(max(eigenvalues,0)), 1-GOF[2])
        \item{stress.m:} explictly normalized stress (manually calculated)
        \item{stoploss:} the weighted loss value
        \item{indices:} the values of the structuredness indices
        \item{parameters:} the parameters used for fitting (lambda)
        \item{fit:} the returned object of the fitting procedure, which is cmdscalex object with some extra slots for the parameters and stresses
         \item{stopobj:} the stopobj object
}
}
\description{
The free parameter is lambda for power transformations of the observed proximities.
}
\keyword{multivariate}
