% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/my_wind_code.R
\name{get_grid_winds}
\alias{get_grid_winds}
\title{Determine hurricane winds at locations}
\usage{
get_grid_winds(hurr_track = stormwindmodel::floyd_tracks,
  grid_df = stormwindmodel::county_points, tint = 0.25,
  gust_duration_cut = 20, sust_duration_cut = 20)
}
\arguments{
\item{hurr_track}{Dataframe with hurricane track data for a single
storm. The dataframe must include columns for date-time (year, month, day,
hour, minute; e.g., "198808051800" for August 5, 1988, 18:00 UTC),
latitude, longitude, and wind speed (in knots). The column
names for each of these must be \code{date}, \code{latitude},
\code{longitude}, and \code{wind}. See the example \code{\link{floyd_tracks}}
dataset for an example of the required format.}

\item{grid_df}{A dataframe of locations at which to calculate wind characteristics.
This dataframe must include columns for latitude and longitude for each
point, and these columns must be named \code{glat} and \code{glon}.
The latitudes and longitudes should be in decimal degrees, with longitudes in the
Western hemisphere (so, almost all those for Atlantic basin storms)
expressed as negative values.}

\item{tint}{Interval (in hours) to which to interpolate the tracks. The
default is 0.25 (i.e., 15 minutes)}

\item{gust_duration_cut}{The wind speed, in meters per second, to use as a
cutoff point for determining the duration of gust winds. The function
will calculate the minutes during the storm when surface-level gust winds
were above this speed at the location.}

\item{sust_duration_cut}{The wind speed, in meters per second, to use as a
cutoff point for determining the duration of gust winds. The function
will calculate the minutes during the storm when surface-level gust winds
were above this speed at the location.}
}
\value{
The dataframe of locations input, with the following columns of wind
characteristics added for each location:
   \itemize{
     \item{\code{vmax_gust}: Maximum value of surface-level (10 meters)
       gust winds, in meters per second, over the length of the
       storm at the given location}
     \item{\code{vmax_sust}: Maximum value of surface-level (10 meters)
       sustained winds, in meters per second, over the length of the
       storm at the given location}
     \item{\code{gust_duration}: Length of time, in minutes, that
       surface-level gust winds were above a specified value (default
       is 20 m / s)}
     \item{\code{sust_duration}: Length of time, in minutes, that
       surface-level sustained winds were above a specified value (default
       is 20 m / s)}
   }
}
\description{
This function inputs a storm track and a dataset of locations and calculates
highest wind speeds (sustained and maximum) and duration of winds above a
certain speed at each location. The dataset of locations can
either be a regularly-spaced grid or can be the central points of locations,
like counties or cities. For counties in the eastern half of the United
States, the \code{county_points} dataset that comes with the package can
be used as the \code{grid_point} input.
}
\note{
This function can take a few minutes to run, depending on the number
of locations that are being modeled.
}
\examples{
\dontrun{
data("floyd_tracks")
data("county_points")
grid_winds <- get_grid_winds(hurr_track = floyd_tracks,
                             grid_df = county_points)
}

}
