% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load-stats19.R
\name{dl_stats19}
\alias{dl_stats19}
\title{Download Stats19 data}
\usage{
dl_stats19(zip_url = paste0("http://data.dft.gov.uk.s3.amazonaws.com/",
  "road-accidents-safety-data/Stats19_Data_2005-2014.zip"),
  data_dir = tempdir())
}
\arguments{
\item{zip_url}{The url where the data is stored}

\item{data_dir}{Directory to which to download the file}
}
\description{
Download Stats19 data
}
\section{Details}{

This convenience function downloads and unzips UK road traffic casualty data.
It results in unzipped .csv data in R's temporary directory.

Ensure you have a fast internet connection and at least 100 Mb space
}

\examples{
\dontrun{
dl_stats19()

# Load all stats19 datasets
ac <- read_stats19_ac()
ca <- read_stats19_ca()
ve <- read_stats19_ve()
# now you can analyse the UK's stats19 data in a single table
}
}
