% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route.R
\name{route}
\alias{route}
\title{Plan routes on the transport network}
\usage{
route(
  from = NULL,
  to = NULL,
  l = NULL,
  route_fun = cyclestreets::journey,
  wait = 0,
  n_print = 10,
  list_output = FALSE,
  cl = NULL,
  ...
)
}
\arguments{
\item{from}{An object representing origins
(if lines are provided as the first argument, from is assigned to \code{l})}

\item{to}{An object representing destinations}

\item{l}{A spatial (linestring) object}

\item{route_fun}{A routing function to be used for converting the lines to routes}

\item{wait}{How long to wait between routes?
0 seconds by default, can be useful when sending requests to rate limited APIs.}

\item{n_print}{A number specifying how frequently progress updates
should be shown}

\item{list_output}{If FALSE (default) assumes spatial (linestring) object output.
Set to TRUE to save output as a list.}

\item{cl}{Cluster}

\item{...}{Arguments passed to the routing function}
}
\description{
Takes origins and destinations, finds the optimal routes between them
and returns the result as a spatial (sf or sp) object.
The definition of optimal depends on the routing function used
}
\examples{
# Todo: add examples
}
\seealso{
Other routes: 
\code{\link{route_dodgr}()},
\code{\link{route_osrm}()}

Other routes: 
\code{\link{route_dodgr}()},
\code{\link{route_osrm}()}
}
\concept{routes}
