% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linefuns.R
\name{line_segment}
\alias{line_segment}
\title{Divide an sf object with LINESTRING geometry into regular segments}
\usage{
line_segment(l, n_segments = NA, segment_length = NA)
}
\arguments{
\item{l}{A spatial lines object}

\item{n_segments}{The number of segments to divide the line into}

\item{segment_length}{The approximate length of segments in the output (overides n_segments if set)}
}
\description{
This function keeps the attributes
}
\examples{
l <- routes_fast_sf[2, ]
l_seg2 <- line_segment(l = l, n_segments = 2)
l_seg3 <- line_segment(l = l, n_segments = 3)
l_seg_100 <- line_segment(l = l, segment_length = 100)
l_seg_2000 <- line_segment(l = l, segment_length = 2000)
plot(sf::st_geometry(l_seg2), col = 1:2, lwd = 5)
plot(sf::st_geometry(l_seg3), col = 1:3, lwd = 5)
plot(sf::st_geometry(l_seg_100), col = seq(nrow(l_seg_100)), lwd = 5)
plot(sf::st_geometry(l_seg_2000), col = seq(nrow(l_seg_100)), lwd = 5)
# Multiple lines
l <- routes_fast_sf[2:4, ]
l_seg_multi = line_segment(l, segment_length = 1000)
plot(sf::st_geometry(l_seg_multi), col = seq(nrow(l_seg_100)), lwd = 5)
}
\seealso{
Other lines: 
\code{\link{angle_diff}()},
\code{\link{geo_toptail}()},
\code{\link{is_linepoint}()},
\code{\link{line2df}()},
\code{\link{line2points}()},
\code{\link{line_bearing}()},
\code{\link{line_breakup}()},
\code{\link{line_midpoint}()},
\code{\link{line_via}()},
\code{\link{mats2line}()},
\code{\link{n_vertices}()},
\code{\link{onewaygeo}()},
\code{\link{points2line}()},
\code{\link{toptail_buff}()}
}
\concept{lines}
