% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/locus.cols.R, R/locus.names.R, R/num.loci.R
\name{locus.cols}
\alias{locus.cols}
\alias{locus.names}
\alias{num.loci}
\title{Locus Information}
\usage{
locus.cols(x, g = NULL)

locus.names(locus.data)

num.loci(locus.data)
}
\arguments{
\item{x}{vector of locus numbers or locus names.}

\item{g}{a \code{\link{gtypes}} object to look for locus names in if \code{x} is a character.}

\item{locus.data}{vector or matrix of genetic data.}
}
\value{
\tabular{ll}{
  \code{locus.names} \tab a character vector of names of loci.\cr
  \code{locus.cols} \tab a matrix of columns in the \code{genotypes} element of \code{g} for the specified loci in \code{x}.\cr
  \code{num.loci} \tab x.\cr
}
}
\description{
Helper functions for locus information from \code{gtypes} objects.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

