% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/num.missing.R
\name{num.missing}
\alias{num.missing}
\title{Number Missing Data}
\usage{
num.missing(g, prop = FALSE)
}
\arguments{
\item{g}{a \code{\link{gtypes}} object.}

\item{prop}{logical determining whether to return proportion missing.}
}
\value{
a vector of loci with number (or, if \code{prop = TRUE}, the proportion)
  of individuals missing data for at least one allele.
}
\description{
Calculate the number of individuals with missing data.
}
\examples{
data(dolph.strata)
data(dolph.msats)
msat.merge <- merge(dolph.strata, dolph.msats, by = "ids", all.y = TRUE, sort = FALSE)
msats <- gtypes(msat.merge, id.col = 1, strata.col = 3, locus.col = 5)
num.missing(msats)
num.missing(msats, prop = TRUE)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

