% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genepop.R
\name{genepop}
\alias{genepop}
\alias{genepopWrite}
\title{Run GENEPOP}
\usage{
genepop(g, output.ext = "", show.output = F, label = "genepop.run",
  dem = 10000, batches = 100, iter = 5000, other.settings = "",
  input.fname = "loc_data.txt", exec = "Genepop")

genepopWrite(g, label = "genepop.write", input.fname = "loc_data.txt")
}
\arguments{
\item{g}{a \code{\link{gtypes}} object.}

\item{output.ext}{character string to use as extension for output files.}

\item{show.output}{logical. Show GENEPOP output on console?}

\item{label}{character string to use to label GENEPOP input and output files.}

\item{dem}{integer giving the number of MCMC dememorisation or burnin steps.}

\item{batches}{integer giving number of MCMC batches.}

\item{iter}{integer giving number of MCMC iterations.}

\item{other.settings}{character string of optional GENEPOP command line 
arguments.}

\item{input.fname}{character string to use for input file name.}

\item{exec}{name of Genepop executable}
}
\value{
\describe{
  \item{\code{genepop}}{a list with a vector of the locus names and a vector 
    of the input and output filenames}
  \item{\code{genepopWrite}}{a vector of the locus names used in the 
    input file}
}
}
\description{
Format output files and run GENEPOP. Filenames used are returned 
  so that output files can be viewed or read and parsed into R.
}
\note{
GENEPOP is not included with \code{strataG} and must be downloaded 
  separately. Additionally, it must be installed such that it can be run from 
  the command line in the current working directory. See the vignette 
  for \code{external.programs} for installation instructions.
}
\examples{
\dontrun{
# Estimate Nm for the microsatellite data
data(msats.g)
# Run Genepop for Option 4
results <- genepop(msats.g, output.ext = ".PRI", other.settings = "MenuOptions=4")
# Locus name mapping and files
results
# Show contents of output file
file.show(results$files["output.fname"])
}

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
GENEPOP 4.3 (08 July 2014; Rousset, 2008)\cr
  \url{http://kimura.univ-montp2.fr/~rousset/Genepop.htm}
}
\seealso{
\link{hweTest}, \link{LDgenepop}
}

