% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldNe.R
\name{ldNe}
\alias{ldNe}
\title{ldNe}
\usage{
ldNe(
  g,
  maf.threshold = 0,
  by.strata = FALSE,
  ci = 0.95,
  drop.missing = FALSE,
  num.cores = 1
)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{maf.threshold}{smallest minimum allele frequency permitted to include 
a locus in calculation of Ne.}

\item{by.strata}{apply the `maf.threshold` by strata. If `TRUE`
then loci that are below this threshold in any strata will be removed 
from the calculation of Ne for all strata. Loci below `maf.threshold` 
within a stratum are always removed for calculations of Ne for that 
stratum.}

\item{ci}{central confidence interval.}

\item{drop.missing}{drop loci with missing genotypes? If `FALSE`, a slower 
procedure is used where individuals with missing genotypes are removed 
in a pairwise fashion.}

\item{num.cores}{The number of cores to use to distribute computations over.
If set to \code{NULL}, the value will be what is reported 
by \code{\link[parallel]{detectCores} - 1}.}
}
\value{
a data.frame with one row per strata and the following columns:
\describe{
 \item{\code{stratum}}{stratum being summarized}
 \item{\code{S}}{harmonic mean of sample size across pairwise comparisons of
 loci}
 \item{\code{num.comp}}{number of pairwise loci comparisons used}
 \item{\code{mean.rsq}}{mean r^2 over all loci}
 \item{\code{mean.E.rsq}}{mean expected r^2 over all loci}
 \item{\code{Ne}}{estimated Ne}
 \item{\code{param.lci, param.uci}}{parametric lower and upper CIs}
}
}
\description{
Estimate Ne from linkage disequilibrium based on Pearson 
  correlation approximation following Waples et al 2016. Adapted from code 
  by R. Waples and W. Larson.
}
\references{
Waples, R.S. 2006. A bias correction for estimates of effective
  population size based on linkage disequilibrium at unlinked gene loci.
  Conservation Genetics 7:167-184. \cr
  Waples RK, Larson WA, and Waples RS. 2016. Estimating contemporary 
  effective population size in non-model species using linkage 
  disequilibrium across thousands of loci. Heredity 117:233-240; 
  doi:10.1038/hdy.2016.60
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
