% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeGtypes.R
\name{writeGtypes}
\alias{writeGtypes}
\title{Write \code{gtypes}}
\usage{
writeGtypes(
  g,
  label = NULL,
  folder = NULL,
  by.strata = TRUE,
  as.frequency = FALSE,
  freq.type = c("freq", "prop"),
  ...
)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{label}{label for filename(s). Default is the gtypes description 
if present.}

\item{folder}{folder where file(s) should be written to. If \code{NULL}, 
files are written to current working directory.}

\item{by.strata}{if \code{as.frequency == TRUE}, calculate frequencies by strata?}

\item{as.frequency}{logical indicating if haploid data should be output 
as frequency tables.}

\item{freq.type}{if \code{as.frequency == TRUE}, write absolute frequencies 
(\code{"freq"}) or proportions (\code{"prop"}).}

\item{...}{optional arguments controlling what information is included in the 
genotype file and how it is formatted passed to \link[strataG]{as.matrix}.}
}
\description{
Write a \linkS4class{gtypes} object to file(s).
}
\details{
Writes a comma-delimited (.csv) file of genotypes and if sequences 
  are present, a .fasta file for each locus. If haploid and \code{as.frequency} 
  is \code{TRUE}, then frequency tables for each locus are written to 
  separate files.
}
\examples{
\dontrun{
# Write microsatellites with one column per locus
data(msats.g)
writeGtypes(msats.g, one.col = TRUE)

# Write control region data as frequency tables
data(dloop.g)
writeGtypes(dloop.g, as.frequency = TRUE)
}

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
