% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nopt.R
\name{rNa}
\alias{rNa}
\title{Recursive Neyman Optimal Allocation Algorithm for Optimal Sample Allocation in Stratified Sampling Scheme}
\usage{
rNa(d, M, n, verbose = FALSE)
}
\arguments{
\item{d}{a numeric vector, equal to (element-wise) multiplication of strata sizes by standard deviations of a study variable in strata.}

\item{M}{a numeric vector, upper bounds constraints on sample sizes in strata. It must be that \code{0 < M <= N}, where \code{N - strata sizes}.}

\item{n}{integer, total sample size.}

\item{verbose}{logical, if \emph{TRUE}, more interim variables from chosen algorithm are returned. Not used in current version.}
}
\value{
Numeric vector with optimal sample allocations in strata.
}
\description{
Implementation of the Recursive Neyman optimal allocation algorithm, with enhancement allowing \code{M <= N} (without enhancement \code{M = N}), where \eqn{N} denotes vector of strata sizes.
The Recursion Neyman optimal allocation algorithm is described in Remark 12.7.1 in Sarndal et al. (1992), and it computes the optimal sample allocation in stratified sampling scheme with simple random sampling without replacement design in each stratum.
Details of the enhancement, including the proof are given in Wojciak (2019).
}
\examples{
N <- c(3000, 4000, 5000, 2000)
S <- rep(1, 4)
rNa(d = N * S, M = c(100, 90, 70, 80), n = 190)

}
\references{
Wojciak W. (2019) \emph{Optimal allocation in stratified sampling schemes}.
  Master's diploma thesis, Warsaw University of Technology. \url{http://home.elka.pw.edu.pl/~wwojciak/msc_optimal_allocation.pdf} \cr
  Sarndal, C.-E., Swensson, B., and Wretman, J. (1992) \emph{Model Assisted Survey Sampling}. Springer.
}
