/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import moa.classifiers.Classifier;
import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.core.TimingUtils;
import moa.evaluation.ClassificationPerformanceEvaluator;
import moa.evaluation.LearningCurve;
import moa.evaluation.LearningEvaluation;
import moa.options.ClassOption;
import moa.options.FileOption;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.tasks.MainTask;
import moa.tasks.TaskMonitor;
import weka.core.Instance;
import weka.core.Instances;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluateInterleavedChunks
extends MainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption learnerOption = new ClassOption("learner", 'l', "Classifier to train.", Classifier.class, "NaiveBayes");
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to learn from.", InstanceStream.class, "generators.RandomTreeGenerator");
    public ClassOption evaluatorOption = new ClassOption("evaluator", 'e', "Classification performance evaluation method.", ClassificationPerformanceEvaluator.class, "BasicClassificationPerformanceEvaluator");
    public IntOption instanceLimitOption = new IntOption("instanceLimit", 'i', "Maximum number of instances to test/train on  (-1 = no limit).", 100000000, -1, Integer.MAX_VALUE);
    public IntOption chunkSizeOption = new IntOption("chunkSize", 'c', "Number of instances in a data chunk.", 1000, 1, Integer.MAX_VALUE);
    public IntOption timeLimitOption = new IntOption("timeLimit", 't', "Maximum number of seconds to test/train for (-1 = no limit).", -1, -1, Integer.MAX_VALUE);
    public IntOption sampleFrequencyOption = new IntOption("sampleFrequency", 'f', "How many instances between samples of the learning performance.", 100000, 0, Integer.MAX_VALUE);
    public IntOption maxMemoryOption = new IntOption("maxMemory", 'b', "Maximum size of model (in bytes). -1 = no limit.", -1, -1, Integer.MAX_VALUE);
    public IntOption memCheckFrequencyOption = new IntOption("memCheckFrequency", 'q', "How many instances between memory bound checks.", 100000, 0, Integer.MAX_VALUE);
    public FileOption dumpFileOption = new FileOption("dumpFile", 'd', "File to append intermediate csv reslts to.", null, "csv", true);

    @Override
    public String getPurposeString() {
        return "Evaluates a classifier on a stream by testing then training with chunks of data in sequence.";
    }

    @Override
    public Class<?> getTaskResultType() {
        return LearningCurve.class;
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        Classifier learner = (Classifier)this.getPreparedClassOption(this.learnerOption);
        InstanceStream stream = (InstanceStream)this.getPreparedClassOption(this.streamOption);
        ClassificationPerformanceEvaluator evaluator = (ClassificationPerformanceEvaluator)this.getPreparedClassOption(this.evaluatorOption);
        learner.setModelContext(stream.getHeader());
        int maxInstances = this.instanceLimitOption.getValue();
        int chunkSize = this.chunkSizeOption.getValue();
        long instancesProcessed = 0L;
        int maxSeconds = this.timeLimitOption.getValue();
        int secondsElapsed = 0;
        monitor.setCurrentActivity("Evaluating learner...", -1.0);
        LearningCurve learningCurve = new LearningCurve("learning evaluation instances");
        File dumpFile = this.dumpFileOption.getFile();
        PrintStream immediateResultStream = null;
        if (dumpFile != null) {
            try {
                immediateResultStream = dumpFile.exists() ? new PrintStream(new FileOutputStream(dumpFile, true), true) : new PrintStream(new FileOutputStream(dumpFile), true);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to open immediate result file: " + dumpFile, ex);
            }
        }
        boolean firstDump = true;
        boolean firstChunk = true;
        boolean preciseCPUTiming = TimingUtils.enablePreciseTiming();
        long evaluateStartTime = TimingUtils.getNanoCPUTimeOfCurrentThread();
        long sampleTestTime = 0L;
        long sampleTrainTime = 0L;
        double RAMHours = 0.0;
        while (!(!stream.hasMoreInstances() || maxInstances >= 0 && instancesProcessed >= (long)maxInstances || maxSeconds >= 0 && secondsElapsed >= maxSeconds)) {
            Instances chunkInstances = new Instances(stream.getHeader(), chunkSize);
            while (stream.hasMoreInstances() && chunkInstances.numInstances() < chunkSize) {
                chunkInstances.add(stream.nextInstance());
                if (chunkInstances.numInstances() % 10 != 0) continue;
                if (monitor.taskShouldAbort()) {
                    return null;
                }
                long estimatedRemainingInstances = stream.estimatedRemainingInstances();
                if (maxInstances > 0) {
                    long maxRemaining = (long)maxInstances - instancesProcessed;
                    if (estimatedRemainingInstances < 0L || maxRemaining < estimatedRemainingInstances) {
                        estimatedRemainingInstances = maxRemaining;
                    }
                }
                monitor.setCurrentActivityFractionComplete((double)instancesProcessed / (double)(instancesProcessed + estimatedRemainingInstances));
            }
            long testStartTime = TimingUtils.getNanoCPUTimeOfCurrentThread();
            if (!firstChunk) {
                for (int i = 0; i < chunkInstances.numInstances(); ++i) {
                    Instance testInst = (Instance)chunkInstances.instance(i).copy();
                    double[] prediction = learner.getVotesForInstance(testInst);
                    evaluator.addResult(testInst, prediction);
                }
            } else {
                firstChunk = false;
            }
            sampleTestTime += TimingUtils.getNanoCPUTimeOfCurrentThread() - testStartTime;
            long trainStartTime = TimingUtils.getNanoCPUTimeOfCurrentThread();
            for (int i = 0; i < chunkInstances.numInstances(); ++i) {
                learner.trainOnInstance(chunkInstances.instance(i));
                ++instancesProcessed;
            }
            sampleTrainTime += TimingUtils.getNanoCPUTimeOfCurrentThread() - trainStartTime;
            if (instancesProcessed % (long)this.sampleFrequencyOption.getValue() == 0L) {
                double RAMHoursIncrement = (double)learner.measureByteSize() / 1.073741824E9;
                RAMHours += (RAMHoursIncrement *= TimingUtils.nanoTimeToSeconds(sampleTrainTime + sampleTestTime) / 3600.0);
                double avgTrainTime = TimingUtils.nanoTimeToSeconds(sampleTrainTime) / ((double)this.sampleFrequencyOption.getValue() / (double)chunkInstances.numInstances());
                double avgTestTime = TimingUtils.nanoTimeToSeconds(sampleTestTime) / ((double)this.sampleFrequencyOption.getValue() / (double)chunkInstances.numInstances());
                sampleTestTime = 0L;
                sampleTrainTime = 0L;
                learningCurve.insertEntry(new LearningEvaluation(new Measurement[]{new Measurement("learning evaluation instances", instancesProcessed), new Measurement("evaluation time (" + (preciseCPUTiming ? "cpu " : "") + "seconds)", TimingUtils.nanoTimeToSeconds(TimingUtils.getNanoCPUTimeOfCurrentThread() - evaluateStartTime)), new Measurement("average chunk train time", avgTrainTime), new Measurement("average chunk train speed", (double)chunkInstances.numInstances() / avgTrainTime), new Measurement("average chunk test time", avgTestTime), new Measurement("average chunk test speed", (double)chunkInstances.numInstances() / avgTestTime), new Measurement("model cost (RAM-Hours)", RAMHours)}, evaluator, learner));
                if (immediateResultStream != null) {
                    if (firstDump) {
                        immediateResultStream.println(learningCurve.headerToString());
                        firstDump = false;
                    }
                    immediateResultStream.println(learningCurve.entryToString(learningCurve.numEntries() - 1));
                    immediateResultStream.flush();
                }
            }
            if (instancesProcessed % 10L != 0L) continue;
            if (monitor.taskShouldAbort()) {
                return null;
            }
            long estimatedRemainingInstances = stream.estimatedRemainingInstances();
            if (maxInstances > 0) {
                long maxRemaining = (long)maxInstances - instancesProcessed;
                if (estimatedRemainingInstances < 0L || maxRemaining < estimatedRemainingInstances) {
                    estimatedRemainingInstances = maxRemaining;
                }
            }
            monitor.setCurrentActivityFractionComplete(estimatedRemainingInstances < 0L ? -1.0 : (double)instancesProcessed / (double)(instancesProcessed + estimatedRemainingInstances));
            if (monitor.resultPreviewRequested()) {
                monitor.setLatestResultPreview(learningCurve.copy());
            }
            secondsElapsed = (int)TimingUtils.nanoTimeToSeconds(TimingUtils.getNanoCPUTimeOfCurrentThread() - evaluateStartTime);
        }
        if (immediateResultStream != null) {
            immediateResultStream.close();
        }
        return learningCurve;
    }
}

