% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSD.R
\name{DSD}
\alias{DSD}
\alias{DSD_R}
\alias{description}
\title{Data Stream Data Generator Base Classes}
\usage{
DSD(...)
}
\arguments{
\item{...}{further arguments.}
}
\description{
Abstract base classes for DSD (Data Stream Data Generator).
}
\details{
The \code{DSD} class cannot be instantiated, but it serves as a abstract
base class from which all DSD objects inherit.

\code{DSD} provides common functionality like:
\itemize{
\item \link{get_points}
\item \code{print}
\item \link{plot}
\item \link{reset_stream} (if available)
}

\code{DSD_R} inherits form \code{DSD} and is the abstract parent class for
DSD implemented in R. To create a new R-based implementation there are only
two function that needs to be implemented for a new \code{DSD} subclass
called \code{Foo} would be:
\enumerate{
\item A creator function \code{DSD_Foo()} and
\item a method \code{get_points.DSD_Foo()} for that class.
}
}
\examples{

DSD()

# create data stream with three clusters in 3-dimensional space
stream <- DSD_Gaussians(k=3, d=3)

# get points from stream
get_points(stream, n=5)

# get points with true cluster assignment
p <- get_points(stream, n=5, cluster=TRUE)
attr(p, "cluster")

# plotting the data (scatter plot matrix, first and third dimension, and first
#  two principal components)
plot(stream)
plot(stream, dim=c(1,3))
plot(stream, method="pc")

}
\seealso{
\link{animate},
\link{update}, \link{evaluate}, \link{get_points},
\link{plot}
\link{write_stream.DSD}, \link{reset_stream}
}
\author{
Michael Hahsler
}
