% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC_R.R
\name{DSC_R}
\alias{DSC_R}
\alias{update.DSC_R}
\title{Abstract Class for Implementing R-based Clusterers}
\usage{
DSC_R(...)

\method{update}{DSC_R}(
  object,
  dsd,
  n = 1L,
  verbose = FALSE,
  block = 10000L,
  assignment = FALSE,
  ...
)
}
\arguments{
\item{...}{further arguments.}

\item{object}{a DSC object.}

\item{dsd}{a data stream object.}

\item{n}{number of data points taken from the stream.}

\item{verbose}{logical; show progress?}

\item{block}{process blocks of data to improve speed.}

\item{assignment}{logical; return a vector with cluster assignments?}
}
\description{
Abstract class for implementing R-based clusterers.
}
\details{
\link{DSC_R} cannot be instantiated.

\strong{Implementing new Classes}

To implement a new clusterer you need to create an S3 class with elements \code{description} and
\code{RObj}. \code{RObj} needs to be a reference class with methods:
\itemize{
\item \code{cluster(newdata, ...)}
\item \code{get_microclusters(...)}
\item \code{get_microweights(...)}
\item \code{get_macroclusters(...)}
\item \code{get_macroweights(...)}
\item \code{microToMacro(micro, ...)}
}

See \link{DSC} for details and parameters.

\code{DSC_R} cannot be instantiated.
}
\seealso{
Other DSC: 
\code{\link{DSC_Macro}()},
\code{\link{DSC_Micro}()},
\code{\link{DSC_Static}()},
\code{\link{DSC_TwoStage}()},
\code{\link{DSC}()},
\code{\link{animate_cluster}()},
\code{\link{evaluate.DSC}},
\code{\link{get_assignment}()},
\code{\link{plot.DSC}()},
\code{\link{predict}()},
\code{\link{prune_clusters}()},
\code{\link{read_saveDSC}},
\code{\link{recluster}()}
}
\author{
Michael Hahsler
}
\concept{DSC}
